/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.DependencyVisitor;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.ignore.JavaClassIgnoreResolver;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.Util;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ClassFilePreDecompilationScan
extends AbstractIterationOperation<JavaClassFileModel> {
    private static final Logger LOG = Logging.get(ClassFilePreDecompilationScan.class);
    String UNPARSEABLE_CLASS_CLASSIFICATION = "Unparseable Class File";
    String UNPARSEABLE_CLASS_DESCRIPTION = "This Class file could not be parsed";

    private void addClassFileMetadata(GraphRewrite event, EvaluationContext context, JavaClassFileModel javaClassFileModel) {
        try (FileInputStream fis = new FileInputStream(javaClassFileModel.getFilePath());){
            ClassParser parser = new ClassParser((InputStream)fis, javaClassFileModel.getFilePath());
            JavaClass bcelJavaClass = parser.parse();
            String packageName = bcelJavaClass.getPackageName();
            String qualifiedName = bcelJavaClass.getClassName();
            JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
            JavaClassModel javaClassModel = javaClassService.create(qualifiedName);
            int majorVersion = bcelJavaClass.getMajor();
            int minorVersion = bcelJavaClass.getMinor();
            String simpleName = qualifiedName;
            if (packageName != null && !packageName.isEmpty() && simpleName != null) {
                simpleName = StringUtils.substringAfterLast((String)simpleName, (String)".");
            }
            javaClassFileModel.setMajorVersion(majorVersion);
            javaClassFileModel.setMinorVersion(minorVersion);
            javaClassFileModel.setPackageName(packageName);
            javaClassModel.setSimpleName(simpleName);
            javaClassModel.setPackageName(packageName);
            javaClassModel.setQualifiedName(qualifiedName);
            javaClassModel.setClassFile(javaClassFileModel);
            javaClassModel.setPublic(bcelJavaClass.isPublic());
            javaClassModel.setInterface(bcelJavaClass.isInterface());
            String[] interfaceNames = bcelJavaClass.getInterfaceNames();
            if (interfaceNames != null) {
                for (String interfaceName : interfaceNames) {
                    JavaClassModel interfaceModel = javaClassService.getOrCreatePhantom(interfaceName);
                    javaClassService.addInterface(javaClassModel, interfaceModel);
                }
            }
            String superclassName = bcelJavaClass.getSuperclassName();
            if (!bcelJavaClass.isInterface() && !StringUtils.isBlank((CharSequence)superclassName)) {
                javaClassModel.setExtends(javaClassService.getOrCreatePhantom(superclassName));
            }
            javaClassFileModel.setJavaClass(javaClassModel);
        }
        catch (Exception ex) {
            Object nl = ex.getMessage() != null ? Util.NL + "\t" : " ";
            String message = "BCEL was unable to parse class file '" + javaClassFileModel.getFilePath() + "':" + (String)nl + ex.toString();
            LOG.log(Level.WARNING, message);
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification(event, context, (FileModel)javaClassFileModel, this.UNPARSEABLE_CLASS_CLASSIFICATION, this.UNPARSEABLE_CLASS_DESCRIPTION);
            javaClassFileModel.setParseError(message);
            javaClassFileModel.setSkipDecompilation(true);
        }
    }

    private void filterClassesToDecompile(GraphRewrite event, EvaluationContext context, JavaClassFileModel fileModel) {
        if (fileModel.getSkipDecompilation() != null && fileModel.getSkipDecompilation().booleanValue()) {
            return;
        }
        try (InputStream is = fileModel.asInputStream();){
            WindupJavaConfigurationService configurationService = new WindupJavaConfigurationService(event.getGraphContext());
            boolean shouldScan = fileModel.getPackageName() != null ? configurationService.shouldScanPackage(fileModel.getPackageName()) : configurationService.shouldScanFile(fileModel.getFilePath());
            if (!shouldScan) {
                LOG.fine("Skipping decompilation for: " + fileModel.getFilePath() + " due to configuration!");
                fileModel.setSkipDecompilation(true);
                return;
            }
            if (fileModel.getFileName().contains("$")) {
                return;
            }
            DependencyVisitor dependencyVisitor = new DependencyVisitor();
            ClassReader classReader = new ClassReader(is);
            classReader.accept((ClassVisitor)dependencyVisitor, 0);
            for (String typeReference : dependencyVisitor.classes) {
                if (!this.shouldIgnore(typeReference)) continue;
                LOG.fine("Skipping decompilation for: " + fileModel.getFilePath() + " due javaclass-ignore!");
                fileModel.setSkipDecompilation(true);
                break;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            String message = "ASM was unable to parse class file '" + fileModel.getFilePath() + "':\n\t" + e.getMessage();
            LOG.log(Level.WARNING, message, e);
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification(event, context, (FileModel)fileModel, this.UNPARSEABLE_CLASS_CLASSIFICATION, this.UNPARSEABLE_CLASS_DESCRIPTION);
            fileModel.setParseError(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(GraphRewrite event, EvaluationContext context, JavaClassFileModel fileModel) {
        ExecutionStatistics.get().begin("ClassFilePreDecompilationScan.perform()");
        try {
            this.addClassFileMetadata(event, context, fileModel);
            if (fileModel.getParseError() != null) {
                return;
            }
            this.filterClassesToDecompile(event, context, fileModel);
        }
        finally {
            ExecutionStatistics.get().end("ClassFilePreDecompilationScan.perform()");
        }
    }

    private boolean shouldIgnore(String typeReference) {
        typeReference = typeReference.replace('/', '.').replace('\\', '.');
        return JavaClassIgnoreResolver.singletonInstance().matches(typeReference);
    }

    public String toString() {
        return ClassFilePreDecompilationScan.class.getSimpleName();
    }
}

