/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.condition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.config.condition.NoopEvaluationStrategy;
import org.jboss.windup.config.parameters.FrameContext;
import org.jboss.windup.config.parameters.FrameCreationContext;
import org.jboss.windup.config.parameters.ParameterizedGraphCondition;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileLocationService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.condition.Version;
import org.jboss.windup.rules.apps.java.model.JarArchiveModel;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.util.Maps;

public class Dependency
extends ParameterizedGraphCondition {
    private RegexParameterizedPatternParser groupId;
    private RegexParameterizedPatternParser artifactId;
    private Version version;

    public static Dependency withVersion(Version v) {
        Dependency dependency = new Dependency();
        dependency.version = v;
        return dependency;
    }

    public static Dependency withGroupId(String groupId) {
        Dependency dependency = new Dependency();
        dependency.groupId = new RegexParameterizedPatternParser(groupId);
        return dependency;
    }

    public static Dependency withArtifactId(String artifactId) {
        Dependency dependency = new Dependency();
        dependency.artifactId = new RegexParameterizedPatternParser(artifactId);
        return dependency;
    }

    public Dependency andVersion(Version version) {
        this.version = version;
        return this;
    }

    public Dependency andArtifactId(String artifactId) {
        this.artifactId = new RegexParameterizedPatternParser(artifactId);
        return this;
    }

    public ParameterizedPatternParser getGroupId() {
        return this.groupId;
    }

    public ParameterizedPatternParser getArtifactId() {
        return this.artifactId;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context, EvaluationStrategy evaluationStrategy) {
        FileLocationService fileLocationService = new FileLocationService(event.getGraphContext());
        ArrayList result = new ArrayList();
        HashSet archiveFoundFilePaths = new HashSet();
        Consumer<DependencyFound> archiveModelConsumer = dependencyFound -> {
            FileLocationModel fileLocationModel = fileLocationService.getOrCreate(dependencyFound.getFileModel(), 1, 1, 1, "Dependency Archive Match");
            evaluationStrategy.modelMatched();
            ParameterizedPatternResult groupIdParameterizedPatternResult = dependencyFound.getGroupIdParameterizedPattern();
            ParameterizedPatternResult artifactIdParameterizedPatternResult = dependencyFound.getArtifactIdParameterizedPattern();
            if ((groupIdParameterizedPatternResult == null || groupIdParameterizedPatternResult.submit((Rewrite)event, context)) && (artifactIdParameterizedPatternResult == null || artifactIdParameterizedPatternResult.submit((Rewrite)event, context))) {
                result.add(fileLocationModel);
                archiveFoundFilePaths.add(dependencyFound.getFileModel().getFilePath());
                evaluationStrategy.modelSubmitted((WindupVertexFrame)fileLocationModel);
            } else {
                evaluationStrategy.modelSubmissionRejected();
            }
        };
        GraphService identifiedArchiveModelService = new GraphService(event.getGraphContext(), IdentifiedArchiveModel.class);
        List identifiedArchiveModels = identifiedArchiveModelService.findAll();
        StreamSupport.stream(identifiedArchiveModels.spliterator(), false).filter(identifiedArchiveModel -> identifiedArchiveModel.getCoordinate() != null).map(DependencyFound::new).filter(dependencyFound -> {
            if (this.groupId == null) {
                return true;
            }
            ParameterizedPatternResult groupIdParameterizedPatternResult = this.groupId.parse(((IdentifiedArchiveModel)dependencyFound.getFileModel()).getCoordinate().getGroupId());
            dependencyFound.setGroupIdParameterizedPattern(groupIdParameterizedPatternResult);
            return groupIdParameterizedPatternResult.matches();
        }).filter(dependencyFound -> {
            if (this.artifactId == null) {
                return true;
            }
            ParameterizedPatternResult artifactIdParameterizedPatternResult = this.artifactId.parse(((IdentifiedArchiveModel)dependencyFound.getFileModel()).getCoordinate().getArtifactId());
            dependencyFound.setArtifactIdParameterizedPattern(artifactIdParameterizedPatternResult);
            return artifactIdParameterizedPatternResult.matches();
        }).filter(dependencyFound -> this.version == null || this.version.validate(((IdentifiedArchiveModel)dependencyFound.getFileModel()).getCoordinate().getVersion())).forEach(archiveModelConsumer);
        GraphService jarArchiveModelService = new GraphService(event.getGraphContext(), JarArchiveModel.class);
        List jarArchiveModels = jarArchiveModelService.findAll();
        StreamSupport.stream(jarArchiveModels.spliterator(), false).filter(jarArchiveModel -> !archiveFoundFilePaths.contains(jarArchiveModel.getFilePath())).filter(jarArchiveModel -> jarArchiveModel.getProjectModel() instanceof MavenProjectModel).map(DependencyFound::new).filter(dependencyFound -> {
            if (this.groupId == null) {
                return true;
            }
            ParameterizedPatternResult groupIdParameterizedPatternResult = this.groupId.parse(((MavenProjectModel)((JarArchiveModel)dependencyFound.getFileModel()).getProjectModel()).getGroupId());
            dependencyFound.setGroupIdParameterizedPattern(groupIdParameterizedPatternResult);
            return groupIdParameterizedPatternResult.matches();
        }).filter(dependencyFound -> {
            if (this.artifactId == null) {
                return true;
            }
            ParameterizedPatternResult artifactIdParameterizedPatternResult = this.artifactId.parse(((MavenProjectModel)((JarArchiveModel)dependencyFound.getFileModel()).getProjectModel()).getArtifactId());
            dependencyFound.setArtifactIdParameterizedPattern(artifactIdParameterizedPatternResult);
            return artifactIdParameterizedPatternResult.matches();
        }).filter(dependencyFound -> this.version == null || this.version.validate(((JarArchiveModel)dependencyFound.getFileModel()).getProjectModel().getVersion())).forEach(archiveModelConsumer);
        if (result.isEmpty()) {
            return false;
        }
        this.setResults(event, this.getOutputVariablesName(), result);
        return true;
    }

    public ConditionBuilder as(String as) {
        super.setOutputVariablesName(as);
        return this;
    }

    public String toString() {
        return "Dependency (" + this.groupId + ", " + this.artifactId + ", " + this.version + ")";
    }

    protected boolean evaluateAndPopulateValueStores(GraphRewrite event, EvaluationContext context, final FrameCreationContext frameCreationContext) {
        return this.evaluate(event, context, new EvaluationStrategy(){
            private LinkedHashMap<String, List<WindupVertexFrame>> variables;

            public void modelMatched() {
                this.variables = new LinkedHashMap();
                frameCreationContext.beginNew(this.variables);
            }

            public void modelSubmitted(WindupVertexFrame model) {
                Maps.addListValue(this.variables, (Object)Dependency.this.getVarname(), (Object)model);
            }

            public void modelSubmissionRejected() {
                frameCreationContext.rollback();
            }
        });
    }

    protected boolean evaluateWithValueStore(GraphRewrite event, EvaluationContext context, FrameContext frameContext) {
        boolean result = this.evaluate(event, context, (EvaluationStrategy)new NoopEvaluationStrategy());
        if (!result) {
            frameContext.reject();
        }
        return result;
    }

    protected String getVarname() {
        return this.getOutputVariablesName();
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.groupId != null) {
            result.addAll(this.groupId.getRequiredParameterNames());
        }
        if (this.artifactId != null) {
            result.addAll(this.artifactId.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.groupId != null) {
            this.groupId.setParameterStore(store);
        }
        if (this.artifactId != null) {
            this.artifactId.setParameterStore(store);
        }
    }

    private static class DependencyFound<T extends FileModel> {
        private final T fileModel;
        private ParameterizedPatternResult groupIdParameterizedPattern;
        private ParameterizedPatternResult artifactIdParameterizedPattern;

        DependencyFound(T fileModel) {
            this.fileModel = fileModel;
        }

        public T getFileModel() {
            return this.fileModel;
        }

        public ParameterizedPatternResult getGroupIdParameterizedPattern() {
            return this.groupIdParameterizedPattern;
        }

        public void setGroupIdParameterizedPattern(ParameterizedPatternResult groupIdParameterizedPattern) {
            this.groupIdParameterizedPattern = groupIdParameterizedPattern;
        }

        public ParameterizedPatternResult getArtifactIdParameterizedPattern() {
            return this.artifactIdParameterizedPattern;
        }

        public void setArtifactIdParameterizedPattern(ParameterizedPatternResult artifactIdParameterizedPattern) {
            this.artifactIdParameterizedPattern = artifactIdParameterizedPattern;
        }
    }
}

