/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import com.google.common.collect.Iterables;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.javaee.model.EjbRemoteServiceModel;

public class EjbRemoteServiceModelService
extends GraphService<EjbRemoteServiceModel> {
    public EjbRemoteServiceModelService(GraphContext context) {
        super(context, EjbRemoteServiceModel.class);
    }

    public EjbRemoteServiceModel getOrCreate(Iterable<ProjectModel> applications, JavaClassModel remoteInterface, JavaClassModel implementationClass) {
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[0]);
        pipeline.has("w:winduptype", (Object)"EjbRemoteServiceModel");
        if (remoteInterface != null) {
            pipeline.as("remoteInterface", new String[0]).out(new String[]{"ejbRemoteInterface"}).filter(vertexTraverser -> ((Vertex)vertexTraverser.get()).equals(remoteInterface.getElement())).select("remoteInterface");
        }
        if (implementationClass != null) {
            pipeline.as("implementationClass", new String[0]).out(new String[]{"ejbImplementationClass"}).filter(vertexTraverser -> ((Vertex)vertexTraverser.get()).equals(implementationClass.getElement())).select("implementationClass");
        }
        if (pipeline.hasNext()) {
            EjbRemoteServiceModel result = (EjbRemoteServiceModel)this.frame((Vertex)pipeline.next());
            for (ProjectModel application : applications) {
                if (Iterables.contains(result.getApplications(), (Object)application)) continue;
                result.addApplication(application);
            }
            return result;
        }
        EjbRemoteServiceModel model = (EjbRemoteServiceModel)this.create();
        model.setApplications(applications);
        model.setInterface(remoteInterface);
        model.setImplementationClass(implementationClass);
        return model;
    }
}

