/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.websphere;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.LinkService;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.xml.DiscoverXmlFilesRuleProvider;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverXmlFilesRuleProvider.class}, perform="Discover WebSphere Web Service Extension XML Files")
public class ResolveWebSphereWsExtensionXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"ibm-webservices-ext.xmi").withProperty("rootTagName", (Object)"WsExtension");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        ClassificationModel classificationModel = classificationService.attachClassification(event, context, (FileModel)payload, "mandatory", "WebSphere web service extension descriptor (ibm-webservices-ext)", "WebSphere Webservice Extension XML Deployment Descriptor.  \nThis deployment descriptor extension is IBM specific and it needs to be migrated to JBossWS.  \nJBossWS implements the latest JAX-WS specification, which users can reference for any vendor-agnostic web service usage need.  \nYou can migrate deployment descriptors following the links below.  \n");
        classificationModel.setEffort(3);
        GraphContext graphContext = event.getGraphContext();
        LinkService linkService = new LinkService(graphContext);
        LinkModel documentationEAP6Link = (LinkModel)linkService.create();
        documentationEAP6Link.setDescription("JAX-WS Web Services (JBoss EAP 6)");
        documentationEAP6Link.setLink("https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Development_Guide/chap-JAX-WS_Web_Services.html");
        classificationService.attachLink(classificationModel, documentationEAP6Link);
        LinkModel documentationEAP7Link = (LinkModel)linkService.create();
        documentationEAP7Link.setDescription("Developing JAX-WS Web Services (JBoss EAP 7)");
        documentationEAP7Link.setLink("https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.0/html/developing_web_services_applications/developing_jax_ws_web_services");
        classificationService.attachLink(classificationModel, documentationEAP7Link);
        LinkModel documentationCommunityLink = (LinkModel)linkService.create();
        documentationCommunityLink.setDescription("Assigning Client and Endpoint Configurations (JBoss EAP 7)");
        documentationCommunityLink.setLink("https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.0/html-single/developing_web_services_applications/#ws_endpoint_assign_config");
        classificationService.attachLink(classificationModel, documentationCommunityLink);
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "WebSphere WS Extension", TechnologyTagLevel.IMPORTANT);
    }
}

