/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss.jbpm3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.Jbpm3ProcessModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class, id="Create JBPM Report")
public class CreateJBossJBPMReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_EJB_REPORT = "/reports/templates/jbpm.ftl";
    public static final String REPORT_DESCRIPTION = "This report contains all of the JBPM related resources that were discovered during analysis.";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(Jbpm3ProcessModel.class)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : configurationModel.getInputPaths()) {
                    ProjectModel application = inputPath.getProjectModel();
                    CreateJBossJBPMReportRuleProvider.this.createJbpmReport(event.getGraphContext(), application);
                }
            }

            public String toString() {
                return "CreateJBPM3Report";
            }
        });
    }

    private void createJbpmReport(GraphContext context, ProjectModel application) {
        GraphService jbpmProcessService = new GraphService(context, Jbpm3ProcessModel.class);
        ArrayList<Jbpm3ProcessModel> processModelList = new ArrayList<Jbpm3ProcessModel>();
        for (Jbpm3ProcessModel processModel : jbpmProcessService.findAll()) {
            Set applicationsContainingFile = ProjectTraversalCache.getApplicationsForProject((GraphContext)context, (ProjectModel)processModel.getProjectModel());
            if (!applicationsContainingFile.contains(application)) continue;
            processModelList.add(processModel);
        }
        if (processModelList.isEmpty()) {
            return;
        }
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(300);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("JBPM");
        applicationReportModel.setDescription(REPORT_DESCRIPTION);
        applicationReportModel.setReportIconClass("glyphicon bpm-nav-logo");
        applicationReportModel.setProjectModel(application);
        applicationReportModel.setTemplatePath(TEMPLATE_EJB_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        WindupVertexListModel processes = (WindupVertexListModel)listService.create();
        processes.addAll(processModelList);
        HashMap<String, WindupVertexListModel> additionalData = new HashMap<String, WindupVertexListModel>(1);
        additionalData.put("processes", processes);
        applicationReportModel.setRelatedResource(additionalData);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "jbpmreport_" + application.getName(), "html");
    }
}

