/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss;

import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverWebXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverWebXmlRuleProvider.class}, perform="Discover JBoss Web XML Files")
public class ResolveJBossWebXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveJBossWebXmlRuleProvider.class.getName());

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"jboss-web");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "JBoss Web XML", TechnologyTagLevel.IMPORTANT);
        Document doc = xmlFileService.loadDocumentQuiet(event, context, payload);
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "web.xml");
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)payload.getProjectModel());
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "res-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-env-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "resource-env-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("message-destination-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "message-destination-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "ejb-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-local-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "ejb-ref-name", "local-jndi-name");
        }
    }

    private void processBinding(EnvironmentReferenceService envRefService, JNDIResourceService jndiResourceService, Set<ProjectModel> applications, Element resourceRef, String tagName, String tagJndi) {
        String jndiLocation = JOOX.$((Element)resourceRef).child(tagJndi).text();
        String resourceRefName = JOOX.$((Element)resourceRef).child(tagName).text();
        if (StringUtils.isNotBlank((CharSequence)jndiLocation) && StringUtils.isNotBlank((CharSequence)resourceRefName)) {
            JNDIResourceModel resource = jndiResourceService.createUnique(applications, jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceRefName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceRefName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
    }
}

