/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.datasource;

import java.util.Set;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.AnalyzeJavaFilesRuleProvider;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={AnalyzeJavaFilesRuleProvider.class})
public class DiscoverDataSourceAnnotationRuleProvider
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext context) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"javax.annotation.sql.DataSourceDefinition").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverDataSourceAnnotationRuleProvider.this.extractDataSourceMetadata(event, payload);
            }
        }).withId(ruleIDPrefix + "_DataSourceDefinition");
    }

    private String getAnnotationLiteralValue(JavaAnnotationTypeReferenceModel model, String name) {
        JavaAnnotationTypeValueModel valueModel = (JavaAnnotationTypeValueModel)model.getAnnotationValues().get(name);
        if (valueModel instanceof JavaAnnotationLiteralTypeValueModel) {
            JavaAnnotationLiteralTypeValueModel literalTypeValue = (JavaAnnotationLiteralTypeValueModel)valueModel;
            return literalTypeValue.getLiteralValue();
        }
        return null;
    }

    private void extractDataSourceMetadata(GraphRewrite event, JavaTypeReferenceModel javaTypeReference) {
        String isXaString;
        javaTypeReference.getFile().setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)javaTypeReference;
        JavaClassModel datasourceClass = this.getJavaClass(javaTypeReference);
        String dataSourceName = this.getAnnotationLiteralValue(annotationTypeReference, "name");
        if (Strings.isNullOrEmpty((String)dataSourceName)) {
            dataSourceName = datasourceClass.getClassName();
        }
        boolean isXa = (isXaString = this.getAnnotationLiteralValue(annotationTypeReference, "transactional")) == null || Boolean.getBoolean(isXaString);
        GraphService dataSourceService = new GraphService(event.getGraphContext(), DataSourceModel.class);
        DataSourceModel dataSourceModel = (DataSourceModel)dataSourceService.create();
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)javaTypeReference.getFile().getProjectModel());
        dataSourceModel.setApplications(applications);
        dataSourceModel.setName(dataSourceName);
        dataSourceModel.setXa(isXa);
        dataSourceModel.setJndiLocation(dataSourceName);
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        AbstractJavaSourceModel javaSource = javaTypeReference.getFile();
        for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
            if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
            result = javaClassModel;
            break;
        }
        if (result == null) {
            result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
        }
        return result;
    }

    public String toString() {
        return "DiscoverDataSource";
    }
}

