/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.decompiler.FernflowerDecompilerOperation;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.AmbiguousJavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.model.PhantomJavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.AnalyzeJavaFilesRuleProvider;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.EjbDeploymentDescriptorModel;
import org.jboss.windup.rules.apps.javaee.model.EjbEntityBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceTagType;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.xml.DoctypeUtils;
import org.jboss.windup.util.xml.NamespaceUtils;
import org.joox.JOOX;
import org.joox.Match;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={AnalyzeJavaFilesRuleProvider.class}, perform="Discover EJB-JAR XML Files and other EJBs")
public class DiscoverEjbConfigurationXmlRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(DiscoverEjbConfigurationXmlRuleProvider.class.getName());
    private static final String TECH_TAG = "EJB XML";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;
    private static final String REGEX_DTD = "(?i).*enterprise.javabeans.*";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"ejb-jar")).perform((Operation)new AbstractIterationOperation<XmlFileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
                try {
                    Document doc = new XmlFileService(event.getGraphContext()).loadDocument(event, context, payload);
                    DiscoverEjbConfigurationXmlRuleProvider.this.extractMetadata(event, context, payload, doc);
                }
                catch (Exception ex) {
                    payload.setParseError("Failed to parse EJB-JAR definitions: " + ex.getMessage());
                }
            }
        }).addRule().when((Condition)JavaClass.references((String)"{ee-flavor}.ejb.EntityBean").at(new TypeReferenceLocation[]{TypeReferenceLocation.IMPLEMENTS_TYPE})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                payload.getFile().setGenerateSourceReport(true);
                List classes = payload.getFile().getJavaClasses();
                classes.forEach(classModel -> {
                    GraphService ejbEntityService = new GraphService(event.getGraphContext(), EjbEntityBeanModel.class);
                    List<EjbEntityBeanModel> entityBeanModels = DiscoverEjbConfigurationXmlRuleProvider.this.findByClass(event.getGraphContext(), "ejbImplementationClass", (JavaClassModel)classModel, EjbEntityBeanModel.class);
                    if (entityBeanModels.iterator().hasNext()) {
                        return;
                    }
                    EjbEntityBeanModel entity = (EjbEntityBeanModel)ejbEntityService.create();
                    entity.setApplications(payload.getFile().getApplications());
                    entity.setEjbClass((JavaClassModel)classModel);
                });
            }
        }).where("ee-flavor").matches("javax|jakarta").addRule().when((Condition)JavaClass.references((String)"{ee-flavor}.ejb.EJBHome").at(new TypeReferenceLocation[]{TypeReferenceLocation.INHERITANCE})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                payload.getFile().setGenerateSourceReport(true);
                List classes = payload.getFile().getJavaClasses();
                classes.forEach(classModel -> {
                    GraphService ejbSessionService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
                    List<EjbSessionBeanModel> sessionModels = DiscoverEjbConfigurationXmlRuleProvider.this.findByClass(event.getGraphContext(), "ejbHome", (JavaClassModel)classModel, EjbSessionBeanModel.class);
                    if (sessionModels.iterator().hasNext()) {
                        return;
                    }
                    EjbSessionBeanModel sessionBeanModel = (EjbSessionBeanModel)ejbSessionService.create();
                    sessionBeanModel.setApplications(payload.getFile().getApplications());
                    sessionBeanModel.setEjbHome((JavaClassModel)classModel);
                });
            }
        }).where("ee-flavor").matches("javax|jakarta").addRule().when((Condition)JavaClass.references((String)"{ee-flavor}.ejb.EJBObject").at(new TypeReferenceLocation[]{TypeReferenceLocation.INHERITANCE})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                payload.getFile().setGenerateSourceReport(true);
                List classes = payload.getFile().getJavaClasses();
                classes.forEach(classModel -> {
                    GraphService ejbSessionService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
                    List<EjbSessionBeanModel> sessionModels = DiscoverEjbConfigurationXmlRuleProvider.this.findByClass(event.getGraphContext(), "ejbRemote", (JavaClassModel)classModel, EjbSessionBeanModel.class);
                    if (sessionModels.iterator().hasNext()) {
                        return;
                    }
                    EjbSessionBeanModel sessionBeanModel = (EjbSessionBeanModel)ejbSessionService.create();
                    sessionBeanModel.setApplications(payload.getFile().getApplications());
                    sessionBeanModel.setEjbRemote((JavaClassModel)classModel);
                });
            }
        }).where("ee-flavor").matches("javax|jakarta").addRule().when((Condition)JavaClass.references((String)"{ee-flavor}.ejb.SessionBean").at(new TypeReferenceLocation[]{TypeReferenceLocation.IMPLEMENTS_TYPE})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                payload.getFile().setGenerateSourceReport(true);
                List classes = payload.getFile().getJavaClasses();
                classes.forEach(classModel -> {
                    GraphService ejbSessionService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
                    List<EjbSessionBeanModel> sessionModels = DiscoverEjbConfigurationXmlRuleProvider.this.findByClass(event.getGraphContext(), "ejbImplementationClass", (JavaClassModel)classModel, EjbSessionBeanModel.class);
                    if (sessionModels.iterator().hasNext()) {
                        return;
                    }
                    EjbSessionBeanModel sessionBeanModel = (EjbSessionBeanModel)ejbSessionService.create();
                    sessionBeanModel.setApplications(payload.getFile().getApplications());
                    sessionBeanModel.setEjbClass((JavaClassModel)classModel);
                });
            }
        }).where("ee-flavor").matches("javax|jakarta").addRule().when((Condition)JavaClass.references((String)"{ee-flavor}.ejb.EJBLocalHome").at(new TypeReferenceLocation[]{TypeReferenceLocation.INHERITANCE})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                payload.getFile().setGenerateSourceReport(true);
                List classes = payload.getFile().getJavaClasses();
                classes.forEach(classModel -> {
                    GraphService ejbSessionService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
                    List<EjbSessionBeanModel> sessionModels = DiscoverEjbConfigurationXmlRuleProvider.this.findByClass(event.getGraphContext(), "ejbLocalHome", (JavaClassModel)classModel, EjbSessionBeanModel.class);
                    if (sessionModels.iterator().hasNext()) {
                        return;
                    }
                    EjbSessionBeanModel sessionBeanModel = (EjbSessionBeanModel)ejbSessionService.create();
                    sessionBeanModel.setApplications(payload.getFile().getApplications());
                    sessionBeanModel.setEjbLocalHome((JavaClassModel)classModel);
                });
            }
        }).where("ee-flavor").matches("javax|jakarta").addRule().when((Condition)JavaClass.references((String)"{ee-flavor}.ejb.EJBLocalObject").at(new TypeReferenceLocation[]{TypeReferenceLocation.INHERITANCE})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                payload.getFile().setGenerateSourceReport(true);
                List classes = payload.getFile().getJavaClasses();
                classes.forEach(classModel -> {
                    GraphService ejbSessionService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
                    List<EjbSessionBeanModel> sessionModels = DiscoverEjbConfigurationXmlRuleProvider.this.findByClass(event.getGraphContext(), "ejbLocal", (JavaClassModel)classModel, EjbSessionBeanModel.class);
                    if (sessionModels.iterator().hasNext()) {
                        return;
                    }
                    EjbSessionBeanModel sessionBeanModel = (EjbSessionBeanModel)ejbSessionService.create();
                    sessionBeanModel.setApplications(payload.getFile().getApplications());
                    sessionBeanModel.setEjbLocal((JavaClassModel)classModel);
                });
            }
        }).where("ee-flavor").matches("javax|jakarta").addRule().when((Condition)JavaClass.references((String)"{ee-flavor}.ejb.MessageDrivenBean").at(new TypeReferenceLocation[]{TypeReferenceLocation.IMPLEMENTS_TYPE})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                payload.getFile().setGenerateSourceReport(true);
                List classes = payload.getFile().getJavaClasses();
                classes.forEach(classModel -> {
                    GraphService ejbMessageDrivenService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
                    List<EjbMessageDrivenModel> messageDrivenModels = DiscoverEjbConfigurationXmlRuleProvider.this.findByClass(event.getGraphContext(), "ejbImplementationClass", (JavaClassModel)classModel, EjbMessageDrivenModel.class);
                    if (messageDrivenModels.iterator().hasNext()) {
                        return;
                    }
                    EjbMessageDrivenModel messageDrivenModel = (EjbMessageDrivenModel)ejbMessageDrivenService.create();
                    messageDrivenModel.setApplications(payload.getFile().getApplications());
                    messageDrivenModel.setEjbClass((JavaClassModel)classModel);
                });
            }
        }).where("ee-flavor").matches("javax|jakarta");
    }

    public <T> List<T> findByClass(GraphContext graphContext, String edgeLabel, JavaClassModel javaClassModel, Class<T> typeClass) {
        ArrayList result = new ArrayList();
        graphContext.getGraph().traversal().V(new Object[0]).has("qualifiedName", (Object)javaClassModel.getQualifiedName()).has("w:winduptype", (Object)"JavaClassModel").in(new String[]{edgeLabel}).toList().forEach(v -> {
            Object frame = graphContext.getFramed().frameElement((Element)v, typeClass);
            result.add(frame);
        });
        return result;
    }

    private void extractMetadata(GraphRewrite event, EvaluationContext context, XmlFileModel xmlModel, Document doc) {
        String version;
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        classificationService.attachClassification(event, context, (FileModel)xmlModel, "information", TECH_TAG, "Enterprise Java Bean XML Descriptor.");
        if (xmlModel.getDoctype() != null) {
            if (!this.processDoctypeMatches(xmlModel.getDoctype())) {
                return;
            }
            version = this.processDoctypeVersion(xmlModel.getDoctype());
        } else {
            String namespace = JOOX.$((Document)doc).find("ejb-jar").namespaceURI();
            if (StringUtils.isBlank((CharSequence)namespace)) {
                namespace = doc.getFirstChild().getNamespaceURI();
            }
            if (StringUtils.isBlank((CharSequence)(version = JOOX.$((Document)doc).attr("version")))) {
                for (NamespaceMetaModel ns : xmlModel.getNamespaces()) {
                    if (!StringUtils.equals((CharSequence)ns.getURI(), (CharSequence)namespace)) continue;
                    version = NamespaceUtils.extractVersion((String)ns.getSchemaLocation());
                }
            }
        }
        technologyTagService.addTagToFileModel((FileModel)xmlModel, TECH_TAG, TECH_TAG_LEVEL, version);
        this.extractMetadata(event, context, xmlModel, doc, version);
    }

    private void extractMetadata(GraphRewrite event, EvaluationContext context, XmlFileModel xml, Document doc, String versionInformation) {
        EjbDeploymentDescriptorModel facet = (EjbDeploymentDescriptorModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)xml, EjbDeploymentDescriptorModel.class);
        if (StringUtils.isNotBlank((CharSequence)versionInformation)) {
            facet.setSpecificationVersion(versionInformation);
        }
        for (org.w3c.dom.Element element : JOOX.$((Document)doc).find("session").get()) {
            this.processSessionBeanElement(event, context, facet, element);
        }
        for (org.w3c.dom.Element element : JOOX.$((Document)doc).find("message-driven").get()) {
            this.processMessageDrivenElement(event, context, facet, element);
        }
        for (org.w3c.dom.Element element : JOOX.$((Document)doc).find("entity").get()) {
            this.processEntityElement(event, context, facet, element);
        }
    }

    private boolean processDoctypeMatches(DoctypeMetaModel entry) {
        if (StringUtils.isNotBlank((CharSequence)entry.getPublicId()) && Pattern.matches(REGEX_DTD, entry.getPublicId())) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)entry.getSystemId()) && Pattern.matches(REGEX_DTD, entry.getSystemId());
    }

    private String processDoctypeVersion(DoctypeMetaModel entry) {
        String publicId = entry.getPublicId();
        String systemId = entry.getSystemId();
        String versionInformation = DoctypeUtils.extractVersion((String)publicId, (String)systemId);
        return versionInformation;
    }

    private void processSessionBeanElement(GraphRewrite event, EvaluationContext context, EjbDeploymentDescriptorModel ejbConfig, org.w3c.dom.Element element) {
        String ejbClz;
        String remoteClz;
        String homeClz;
        String localHomeClz;
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)ejbConfig.getProjectModel());
        JavaClassModel home = null;
        JavaClassModel localHome = null;
        JavaClassModel remote = null;
        JavaClassModel local = null;
        JavaClassModel ejb = null;
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String localClz = this.extractChildTagAndTrim(element, "local");
        if (localClz != null) {
            local = this.getOrCreatePhantom(event, context, javaClassService, localClz);
        }
        if ((localHomeClz = this.extractChildTagAndTrim(element, "local-home")) != null) {
            localHome = this.getOrCreatePhantom(event, context, javaClassService, localHomeClz);
        }
        if ((homeClz = this.extractChildTagAndTrim(element, "home")) != null) {
            home = this.getOrCreatePhantom(event, context, javaClassService, homeClz);
        }
        if ((remoteClz = this.extractChildTagAndTrim(element, "remote")) != null) {
            remote = this.getOrCreatePhantom(event, context, javaClassService, remoteClz);
        }
        if ((ejbClz = this.extractChildTagAndTrim(element, "ejb-class")) != null) {
            ejb = this.getOrCreatePhantom(event, context, javaClassService, ejbClz);
        }
        String sessionType = this.extractChildTagAndTrim(element, "session-type");
        String transactionType = this.extractChildTagAndTrim(element, "transaction-type");
        GraphService sessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        EjbSessionBeanModel sessionBean = (EjbSessionBeanModel)sessionBeanService.create();
        sessionBean.setApplications(applications);
        sessionBean.setEjbId(ejbId);
        sessionBean.setDisplayName(displayName);
        sessionBean.setBeanName(ejbName);
        sessionBean.setEjbLocal(local);
        sessionBean.setEjbLocalHome(localHome);
        sessionBean.setEjbHome(home);
        sessionBean.setEjbRemote(remote);
        sessionBean.setEjbClass(ejb);
        sessionBean.setSessionType(sessionType);
        sessionBean.setTransactionType(transactionType);
        List<EnvironmentReferenceModel> refs = this.processEnvironmentReference(event.getGraphContext(), element);
        for (EnvironmentReferenceModel ref : refs) {
            sessionBean.addEnvironmentReference(ref);
        }
        ejbConfig.addEjbSessionBean(sessionBean);
    }

    private void processMessageDrivenElement(GraphRewrite event, EvaluationContext context, EjbDeploymentDescriptorModel ejbConfig, org.w3c.dom.Element element) {
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        JavaClassModel ejb = null;
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)ejbConfig.getProjectModel());
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String ejbClz = this.extractChildTagAndTrim(element, "ejb-class");
        if (ejbClz != null) {
            ejb = this.getOrCreatePhantom(event, context, javaClassService, ejbClz);
        }
        String sessionType = this.extractChildTagAndTrim(element, "session-type");
        String transactionType = this.extractChildTagAndTrim(element, "transaction-type");
        String destination = null;
        for (org.w3c.dom.Element activationConfigPropertyElement : JOOX.$((Match)JOOX.$((org.w3c.dom.Element)element).find("activation-config")).find("activation-config-property").get()) {
            String propName = this.extractChildTagAndTrim(activationConfigPropertyElement, "activation-config-property-name");
            String propValue = this.extractChildTagAndTrim(activationConfigPropertyElement, "activation-config-property-value");
            if (!"destination".equals(propName)) continue;
            destination = propValue;
        }
        destination = StringUtils.trimToNull(destination);
        GraphService sessionBeanService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        EjbMessageDrivenModel mdb = (EjbMessageDrivenModel)sessionBeanService.create();
        mdb.setApplications(applications);
        mdb.setEjbClass(ejb);
        mdb.setBeanName(ejbName);
        mdb.setDisplayName(displayName);
        mdb.setEjbId(ejbId);
        mdb.setSessionType(sessionType);
        mdb.setTransactionType(transactionType);
        if (StringUtils.isNotBlank((CharSequence)destination)) {
            JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
            JmsDestinationModel jndiRef = jmsDestinationService.createUnique(applications, destination);
            mdb.setDestination(jndiRef);
        }
        List<EnvironmentReferenceModel> refs = this.processEnvironmentReference(event.getGraphContext(), element);
        for (EnvironmentReferenceModel ref : refs) {
            mdb.addEnvironmentReference(ref);
        }
        ejbConfig.addMessageDriven(mdb);
    }

    private void processEntityElement(GraphRewrite event, EvaluationContext context, EjbDeploymentDescriptorModel ejbConfig, org.w3c.dom.Element element) {
        String ejbClz;
        String localHomeClz;
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        JavaClassModel localHome = null;
        JavaClassModel local = null;
        JavaClassModel ejb = null;
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)ejbConfig.getProjectModel());
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String tableName = this.extractChildTagAndTrim(element, "table-name");
        String localClz = this.extractChildTagAndTrim(element, "local");
        if (localClz != null) {
            local = this.getOrCreatePhantom(event, context, javaClassService, localClz);
        }
        if ((localHomeClz = this.extractChildTagAndTrim(element, "local-home")) != null) {
            localHome = this.getOrCreatePhantom(event, context, javaClassService, localHomeClz);
        }
        if ((ejbClz = this.extractChildTagAndTrim(element, "ejb-class")) != null) {
            ejb = this.getOrCreatePhantom(event, context, javaClassService, ejbClz);
        }
        String persistenceType = this.extractChildTagAndTrim(element, "persistence-type");
        GraphService ejbEntityService = new GraphService(event.getGraphContext(), EjbEntityBeanModel.class);
        EjbEntityBeanModel entity = (EjbEntityBeanModel)ejbEntityService.create();
        entity.setApplications(applications);
        entity.setPersistenceType(persistenceType);
        entity.setEjbId(ejbId);
        entity.setDisplayName(displayName);
        entity.setBeanName(ejbName);
        entity.setTableName(tableName);
        entity.setEjbClass(ejb);
        entity.setEjbLocalHome(localHome);
        entity.setEjbLocal(local);
        List<EnvironmentReferenceModel> refs = this.processEnvironmentReference(event.getGraphContext(), element);
        for (EnvironmentReferenceModel ref : refs) {
            entity.addEnvironmentReference(ref);
        }
        ejbConfig.addEjbEntityBean(entity);
    }

    private List<EnvironmentReferenceModel> processEnvironmentReference(GraphContext context, org.w3c.dom.Element element) {
        EnvironmentReferenceModel ref;
        String name;
        String type;
        String id;
        EnvironmentReferenceService environmentReferenceService = new EnvironmentReferenceService(context);
        LinkedList<EnvironmentReferenceModel> resources = new LinkedList<EnvironmentReferenceModel>();
        for (org.w3c.dom.Element e : JOOX.$((org.w3c.dom.Element)element).find("resource-ref").get()) {
            id = JOOX.$((org.w3c.dom.Element)e).attr("id");
            type = JOOX.$((org.w3c.dom.Element)e).child("res-type").text();
            name = JOOX.$((org.w3c.dom.Element)e).child("res-ref-name").text();
            type = StringUtils.trim((String)type);
            ref = environmentReferenceService.findEnvironmentReference(name = StringUtils.trim((String)name), EnvironmentReferenceTagType.RESOURCE_REF);
            if (ref == null) {
                ref = (EnvironmentReferenceModel)environmentReferenceService.create();
                ref.setName(name);
                ref.setReferenceId(id);
                ref.setReferenceType(type);
                ref.setReferenceTagType(EnvironmentReferenceTagType.RESOURCE_REF);
            }
            LOG.info("Reference: " + name + ", Type: " + type);
            resources.add(ref);
        }
        for (org.w3c.dom.Element e : JOOX.$((org.w3c.dom.Element)element).find("resource-env-ref").get()) {
            id = JOOX.$((org.w3c.dom.Element)e).attr("id");
            type = JOOX.$((org.w3c.dom.Element)e).child("resource-env-ref-type").text();
            name = JOOX.$((org.w3c.dom.Element)e).child("resource-env-ref-name").text();
            type = StringUtils.trim((String)type);
            ref = environmentReferenceService.findEnvironmentReference(name = StringUtils.trim((String)name), EnvironmentReferenceTagType.RESOURCE_ENV_REF);
            if (ref == null) {
                ref = (EnvironmentReferenceModel)environmentReferenceService.create();
                ref.setReferenceId(id);
                ref.setName(name);
                ref.setReferenceType(type);
                ref.setReferenceTagType(EnvironmentReferenceTagType.RESOURCE_ENV_REF);
            }
            LOG.info("Reference: " + name + ", Type: " + type + ", Tag: " + ref.getReferenceTagType());
            resources.add(ref);
        }
        for (org.w3c.dom.Element e : JOOX.$((org.w3c.dom.Element)element).find("message-destination-ref").get()) {
            id = JOOX.$((org.w3c.dom.Element)e).attr("id");
            type = JOOX.$((org.w3c.dom.Element)e).child("message-destination-type").text();
            name = JOOX.$((org.w3c.dom.Element)e).child("message-destination-ref-name").text();
            type = StringUtils.trim((String)type);
            ref = environmentReferenceService.findEnvironmentReference(name = StringUtils.trim((String)name), EnvironmentReferenceTagType.MSG_DESTINATION_REF);
            if (ref == null) {
                ref = (EnvironmentReferenceModel)environmentReferenceService.create();
                ref.setReferenceId(id);
                ref.setName(name);
                ref.setReferenceType(type);
                ref.setReferenceTagType(EnvironmentReferenceTagType.MSG_DESTINATION_REF);
            }
            LOG.info("Reference: " + name + ", Type: " + type + ", Tag: " + ref.getReferenceTagType());
            resources.add(ref);
        }
        for (org.w3c.dom.Element e : JOOX.$((org.w3c.dom.Element)element).find("ejb-local-ref").get()) {
            id = JOOX.$((org.w3c.dom.Element)e).attr("id");
            type = JOOX.$((org.w3c.dom.Element)e).child("ejb-ref-type").text();
            name = JOOX.$((org.w3c.dom.Element)e).child("ejb-ref-name").text();
            type = StringUtils.trim((String)type);
            ref = environmentReferenceService.findEnvironmentReference(name = StringUtils.trim((String)name), EnvironmentReferenceTagType.EJB_LOCAL_REF);
            if (ref == null) {
                ref = (EnvironmentReferenceModel)environmentReferenceService.create();
                ref.setReferenceId(id);
                ref.setName(name);
                ref.setReferenceType(type);
                ref.setReferenceTagType(EnvironmentReferenceTagType.EJB_LOCAL_REF);
            }
            LOG.info("Reference: " + name + ", Type: " + type + ", Tag: " + ref.getReferenceTagType());
            resources.add(ref);
        }
        for (org.w3c.dom.Element e : JOOX.$((org.w3c.dom.Element)element).find("ejb-ref").get()) {
            id = JOOX.$((org.w3c.dom.Element)e).attr("id");
            type = JOOX.$((org.w3c.dom.Element)e).child("ejb-ref-type").text();
            name = JOOX.$((org.w3c.dom.Element)e).child("ejb-ref-name").text();
            type = StringUtils.trim((String)type);
            ref = environmentReferenceService.findEnvironmentReference(name = StringUtils.trim((String)name), EnvironmentReferenceTagType.EJB_REF);
            if (ref == null) {
                ref = (EnvironmentReferenceModel)environmentReferenceService.create();
                ref.setReferenceId(id);
                ref.setName(name);
                ref.setReferenceType(type);
                ref.setReferenceTagType(EnvironmentReferenceTagType.EJB_REF);
            }
            LOG.info("Reference: " + name + ", Type: " + type + ", Tag: " + ref.getReferenceTagType());
            resources.add(ref);
        }
        return resources;
    }

    private JavaClassModel getOrCreatePhantom(GraphRewrite event, EvaluationContext context, JavaClassService service, String fqcn) {
        JavaClassModel classModel = service.getOrCreatePhantom(fqcn);
        if (classModel instanceof AmbiguousJavaClassModel) {
            for (JavaClassModel reference : ((AmbiguousJavaClassModel)classModel).getReferences()) {
                this.markAsReportReportable(event, context, reference);
            }
        } else if (!(classModel instanceof PhantomJavaClassModel)) {
            this.markAsReportReportable(event, context, classModel);
        }
        return classModel;
    }

    private void markAsReportReportable(GraphRewrite event, EvaluationContext context, JavaClassModel reference) {
        AbstractJavaSourceModel originalSource = reference.getOriginalSource();
        JavaSourceFileModel decompiledSource = reference.getDecompiledSource();
        if (originalSource == null && decompiledSource == null && reference.getClassFile() != null && reference.getClassFile() instanceof JavaClassFileModel) {
            JavaClassFileModel javaClassFileModel = (JavaClassFileModel)reference.getClassFile();
            javaClassFileModel.setSkipDecompilation(false);
            FernflowerDecompilerOperation decompilerOperation = new FernflowerDecompilerOperation();
            decompilerOperation.setFilesToDecompile(Collections.singletonList(javaClassFileModel));
            decompilerOperation.perform(event, context);
            event.getGraphContext().commit();
            if (reference.getDecompiledSource() != null) {
                reference.getDecompiledSource().setGenerateSourceReport(true);
            }
        }
        if (originalSource != null) {
            originalSource.setGenerateSourceReport(true);
        }
        if (decompiledSource != null) {
            decompiledSource.setGenerateSourceReport(true);
        }
    }

    private String extractAttributeAndTrim(org.w3c.dom.Element element, String property) {
        String result = JOOX.$((org.w3c.dom.Element)element).attr(property);
        return StringUtils.trimToNull((String)result);
    }

    private String extractChildTagAndTrim(org.w3c.dom.Element element, String property) {
        String result = JOOX.$((org.w3c.dom.Element)element).find(property).first().text();
        return StringUtils.trimToNull((String)result);
    }
}

