/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.diva.service;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.FileLocationService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.IssueDisplayMode;
import org.jboss.windup.rules.apps.diva.model.DivaStackTraceModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;

public class DivaStackTraceService
extends GraphService<DivaStackTraceModel> {
    FileLocationService fileLocationService;

    public DivaStackTraceService(GraphContext context) {
        super(context, DivaStackTraceModel.class);
        this.fileLocationService = new FileLocationService(context);
    }

    public DivaStackTraceModel getOrCreate(FileModel fileModel, int lineNumber, int columnNumber, int length, DivaStackTraceModel parent, JavaMethodModel method) {
        FileLocationModel location;
        List locs = fileModel.traverse(g -> g.in(new String[]{"file"}).has("w:winduptype", (Object)"FileLocationModel").has("startPosition", (Object)columnNumber).has("lineNumber", (Object)lineNumber).has("length", (Object)length)).toList(FileLocationModel.class);
        DivaStackTraceModel model = null;
        if (locs.isEmpty()) {
            location = (FileLocationModel)this.fileLocationService.create();
            location.setColumnNumber(columnNumber);
            location.setLineNumber(lineNumber);
            location.setLength(length);
            location.setFile(fileModel);
            if (fileModel instanceof SourceFileModel) {
                InlineHintModel inlineHint;
                ((SourceFileModel)fileModel).setGenerateSourceReport(true);
                InlineHintModel inlineHintModel = inlineHint = location instanceof InlineHintModel ? (InlineHintModel)location : (InlineHintModel)DivaStackTraceService.addTypeToModel((GraphContext)this.getGraphContext(), (WindupVertexFrame)location, InlineHintModel.class);
                if (inlineHint.getTitle() == null) {
                    inlineHint.setTitle("Transactions report");
                    inlineHint.setIssueDisplayMode(IssueDisplayMode.DETAIL_ONLY);
                    inlineHint.setHint("---");
                    inlineHint.setEffort(0);
                } else {
                    inlineHint.setTitle(inlineHint.getTitle() + ", Transactions report");
                }
            }
        } else {
            location = (FileLocationModel)locs.get(0);
            GraphTraversal traversal = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{location.getElement()}).in(new String[]{"location"});
            traversal = parent == null ? traversal.not((Traversal)__.out((String[])new String[]{"parent"})) : traversal.filter((Traversal)__.out((String[])new String[]{"parent"}).is((Object)parent.getElement()));
            model = (DivaStackTraceModel)this.getUnique((Traversal)traversal);
        }
        if (model == null) {
            model = (DivaStackTraceModel)this.create();
            model.setLocation(location);
            if (parent != null) {
                model.setParent(parent);
            }
            if (method != null) {
                model.setMethod(method);
            }
        }
        return model;
    }
}

