/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.diva.reporting;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.rules.apps.diva.model.DivaStackTraceModel;

public class StackTraceToList
implements WindupFreeMarkerMethod {
    private static final String NAME = "stackTraceToList";

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + DivaStackTraceModel.class.getSimpleName() + " object, and returns a list of stack traces.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument");
        }
        ArrayList<DivaStackTraceModel> list = new ArrayList<DivaStackTraceModel>();
        StringModel stringModel = (StringModel)arguments.get(0);
        if (stringModel == null) {
            return list;
        }
        if (stringModel.getWrappedObject() != null && !(stringModel.getWrappedObject() instanceof DivaStackTraceModel)) {
            throw new TemplateModelException("Error, method expects argument of type " + DivaStackTraceModel.class.getSimpleName());
        }
        for (DivaStackTraceModel model = (DivaStackTraceModel)stringModel.getWrappedObject(); model != null; model = model.getParent()) {
            list.add(model);
        }
        Collections.reverse(list);
        return list;
    }
}

