/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructField
extends StructMember {
    private final String name;
    private final String descriptor;

    public StructField(DataInputFullStream in, StructClass clStruct) throws IOException {
        this.accessFlags = in.readUnsignedShort();
        int nameIndex = in.readUnsignedShort();
        int descriptorIndex = in.readUnsignedShort();
        ConstantPool pool = clStruct.getPool();
        String[] values = pool.getClassElement(1, clStruct.qualifiedName, nameIndex, descriptorIndex);
        this.name = values[0];
        this.descriptor = values[1];
        this.attributes = this.readAttributes(in, pool);
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.name;
    }
}

