/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.javatuples.Pair;

public final class ChainedComparator<S, C extends Comparable>
implements Comparator<S>,
Serializable,
Cloneable {
    private List<Pair<Traversal.Admin<S, C>, Comparator<C>>> comparators = new ArrayList<Pair<Traversal.Admin<S, C>, Comparator<C>>>();
    private final boolean isShuffle;
    private final boolean traversers;

    public ChainedComparator(boolean traversers, List<Pair<Traversal.Admin<S, C>, Comparator<C>>> comparators) {
        this.traversers = traversers;
        if (comparators.isEmpty()) {
            this.comparators.add(new Pair(new IdentityTraversal(), (Object)Order.asc));
        } else {
            this.comparators.addAll(comparators);
        }
        boolean bl = this.isShuffle = (Comparator)this.comparators.get(this.comparators.size() - 1).getValue1() == Order.shuffle;
        if (!this.isShuffle) {
            this.comparators.removeAll(this.comparators.stream().filter(pair -> (Comparator)pair.getValue1() == Order.shuffle).collect(Collectors.toList()));
        }
    }

    public boolean isShuffle() {
        return this.isShuffle;
    }

    @Override
    public int compare(S objectA, S objectB) {
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> pair : this.comparators) {
            int comparison = this.traversers ? ((Comparator)pair.getValue1()).compare((Comparable)TraversalUtil.apply((Traverser.Admin)objectA, (Traversal.Admin)pair.getValue0()), (Comparable)TraversalUtil.apply((Traverser.Admin)objectB, (Traversal.Admin)pair.getValue0())) : ((Comparator)pair.getValue1()).compare((Comparable)TraversalUtil.apply(objectA, (Traversal.Admin)pair.getValue0()), (Comparable)TraversalUtil.apply(objectB, (Traversal.Admin)pair.getValue0()));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public ChainedComparator<S, C> clone() {
        try {
            ChainedComparator clone = (ChainedComparator)super.clone();
            clone.comparators = new ArrayList<Pair<Traversal.Admin<S, C>, Comparator<C>>>();
            for (Pair<Traversal.Admin<S, C>, Comparator<C>> comparator : this.comparators) {
                clone.comparators.add(new Pair(((Traversal.Admin)comparator.getValue0()).clone(), (Object)((Comparator)comparator.getValue1())));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

