/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.condition.validators;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.rules.apps.xml.condition.validators.XmlFileValidator;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class XmlFileNameValidator
implements XmlFileValidator {
    private RegexParameterizedPatternParser fileNamePattern;

    @Override
    public boolean isValid(GraphRewrite event, EvaluationContext context, XmlFileModel model) {
        if (this.fileNamePattern != null) {
            ParameterStore store = DefaultParameterStore.getInstance((EvaluationContext)context);
            Pattern compiledPattern = this.fileNamePattern.getCompiledPattern(store);
            String pattern = compiledPattern.pattern();
            String fileName = model.getFileName();
            return fileName.matches(pattern);
        }
        return true;
    }

    public void setFileNameRegex(String fileName) {
        this.fileNamePattern = new RegexParameterizedPatternParser(fileName);
    }

    public RegexParameterizedPatternParser getFileNamePattern() {
        return this.fileNamePattern;
    }

    public Collection<? extends String> getRequiredParamaterNames() {
        if (this.fileNamePattern != null) {
            return this.fileNamePattern.getRequiredParameterNames();
        }
        return Collections.emptyList();
    }
}

