/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ast.java.data;

import java.util.Objects;
import org.jboss.windup.ast.java.data.ResolutionStatus;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;

public class ClassReference {
    private final String qualifiedName;
    private final String packageName;
    private final String className;
    private final String methodName;
    private final ResolutionStatus resolutionStatus;
    private final int lineNumber;
    private final int column;
    private final int length;
    private final TypeReferenceLocation location;
    private String line;

    public ClassReference(String qualifiedName, String packageName, String className, String methodName, ResolutionStatus resolutionStatus, TypeReferenceLocation location, int lineNumber, int column, int length, String line) {
        this.qualifiedName = qualifiedName;
        this.packageName = packageName;
        this.className = className;
        this.methodName = methodName;
        this.resolutionStatus = resolutionStatus;
        this.location = location;
        this.lineNumber = lineNumber;
        this.column = column;
        this.length = length;
        this.line = line;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }

    public TypeReferenceLocation getLocation() {
        return this.location;
    }

    public ResolutionStatus getResolutionStatus() {
        return this.resolutionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassReference reference = (ClassReference)o;
        if (this.lineNumber != reference.lineNumber) {
            return false;
        }
        if (this.column != reference.column) {
            return false;
        }
        if (this.length != reference.length) {
            return false;
        }
        if (this.qualifiedName != null ? !this.qualifiedName.equals(reference.qualifiedName) : reference.qualifiedName != null) {
            return false;
        }
        if (!Objects.equals(this.packageName, reference.packageName)) {
            return false;
        }
        if (!Objects.equals(this.className, reference.className)) {
            return false;
        }
        if (this.resolutionStatus != reference.resolutionStatus) {
            return false;
        }
        if (this.location != reference.location) {
            return false;
        }
        return !(this.line == null ? reference.line != null : !this.line.equals(reference.line));
    }

    public int hashCode() {
        int result = this.qualifiedName != null ? this.qualifiedName.hashCode() : 0;
        result = 31 * result + (this.resolutionStatus != null ? this.resolutionStatus.hashCode() : 0);
        result = 31 * result + this.lineNumber;
        result = 31 * result + this.column;
        result = 31 * result + this.length;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClassReference{qualifiedName='" + this.qualifiedName + "', packageName='" + this.packageName + "', className='" + this.className + "', resolutionStatus=" + this.resolutionStatus + ", lineNumber=" + this.lineNumber + ", column=" + this.column + ", length=" + this.length + ", location=" + this.location + ", line='" + this.line + "'}";
    }
}

