/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.BooleanFilter;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;

public class SealedReport
extends AbstractReport {
    private static final String NAME = "Sealed information";
    private static final String DIRECTORY = "sealed";

    public SealedReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Status</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        boolean odd = true;
        int sealed = 0;
        int unsealed = 0;
        for (Archive archive : this.archives) {
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archiveName + "</a></td>" + Dump.newLine());
            if (archive.hasManifestKey("Sealed") && Boolean.TRUE.equals(Boolean.valueOf(archive.getManifestValue("Sealed")))) {
                bw.write("     <td style=\"color: red;\">Sealed</td>" + Dump.newLine());
                ++sealed;
            } else {
                bw.write("     <td style=\"color: green;\">Unsealed</td>" + Dump.newLine());
                ++unsealed;
            }
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
        boolean filtered = this.isFiltered();
        if (sealed > 0 && unsealed > 0 && !filtered) {
            this.status = 1;
        }
        bw.write(Dump.newLine());
        bw.write("<p>" + Dump.newLine());
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Status</th>" + Dump.newLine());
        bw.write("     <th>Archives</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Sealed</td>" + Dump.newLine());
        if (!filtered) {
            bw.write("     <td style=\"color: red;\">" + sealed + "</td>" + Dump.newLine());
        } else {
            bw.write("     <td style=\"color: red; text-decoration: line-through;\">" + sealed + "</td>" + Dump.newLine());
        }
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Unsealed</td>" + Dump.newLine());
        if (!filtered) {
            bw.write("     <td style=\"color: green;\">" + unsealed + "</td>" + Dump.newLine());
        } else {
            bw.write("     <td style=\"color: green; text-decoration: line-through;\">" + unsealed + "</td>" + Dump.newLine());
        }
        bw.write("  </tr>" + Dump.newLine());
        bw.write("</table>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Sealed information</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new BooleanFilter();
    }
}

