/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.ArchiveReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.JarReport;
import org.jboss.tattletale.reporting.WarReport;

public abstract class NestableReport
extends ArchiveReport {
    private NestableArchive nestableArchive;

    public NestableReport(String id, int severity, NestableArchive nestableArchive) {
        super(id, severity, nestableArchive);
        this.nestableArchive = nestableArchive;
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Name</td>" + Dump.newLine());
        bw.write("     <td>" + this.nestableArchive.getName() + "</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Class Version</td>" + Dump.newLine());
        bw.write("     <td>");
        if (50 == this.nestableArchive.getVersion()) {
            bw.write("Java 6");
        } else if (49 == this.nestableArchive.getVersion()) {
            bw.write("Java 5");
        } else if (48 == this.nestableArchive.getVersion()) {
            bw.write("J2SE 1.4");
        } else if (47 == this.nestableArchive.getVersion()) {
            bw.write("J2SE 1.3");
        } else if (46 == this.nestableArchive.getVersion()) {
            bw.write("J2SE 1.2");
        } else if (45 == this.nestableArchive.getVersion()) {
            bw.write("JSE 1.0 / JSE 1.1");
        }
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Locations</td>" + Dump.newLine());
        bw.write("     <td>");
        bw.write("       <table>" + Dump.newLine());
        for (Location location : this.nestableArchive.getLocations()) {
            bw.write("      <tr>" + Dump.newLine());
            bw.write("        <td>" + location.getFilename() + "</td>" + Dump.newLine());
            bw.write("        <td>");
            if (location.getVersion() != null) {
                bw.write(location.getVersion());
            } else {
                bw.write("<i>Not listed</i>");
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("      </tr>" + Dump.newLine());
        }
        bw.write("       </table>" + Dump.newLine());
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Profiles</td>" + Dump.newLine());
        bw.write("     <td>");
        if (this.nestableArchive.getProfiles() != null) {
            Iterator pit = this.nestableArchive.getProfiles().iterator();
            while (pit.hasNext()) {
                String p = (String)pit.next();
                bw.write(p);
                if (!pit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Manifest</td>" + Dump.newLine());
        bw.write("     <td>");
        if (this.nestableArchive.getManifest() != null) {
            Iterator<String> mit = this.nestableArchive.getManifest().iterator();
            while (mit.hasNext()) {
                String m = mit.next();
                bw.write(m);
                if (!mit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Signing information</td>" + Dump.newLine());
        bw.write("     <td>");
        if (this.nestableArchive.getSign() != null) {
            Iterator<String> sit = this.nestableArchive.getSign().iterator();
            while (sit.hasNext()) {
                String s = sit.next();
                bw.write(s);
                if (!sit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Requires</td>" + Dump.newLine());
        bw.write("     <td>");
        Iterator rit = this.nestableArchive.getRequires().iterator();
        while (rit.hasNext()) {
            String require = (String)rit.next();
            bw.write(require);
            if (!rit.hasNext()) continue;
            bw.write("<br>");
        }
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Provides</td>" + Dump.newLine());
        bw.write("     <td>" + Dump.newLine());
        bw.write("       <table>" + Dump.newLine());
        for (Map.Entry entry : this.nestableArchive.getProvides().entrySet()) {
            String name = (String)entry.getKey();
            Long serialVersionUID = (Long)entry.getValue();
            bw.write("         <tr>" + Dump.newLine());
            bw.write("           <td>" + name + "</td>" + Dump.newLine());
            if (serialVersionUID != null) {
                bw.write("           <td>" + serialVersionUID + "</td>" + Dump.newLine());
            } else {
                bw.write("           <td>&nbsp;</td>" + Dump.newLine());
            }
            bw.write("         </tr>" + Dump.newLine());
        }
        bw.write("       </table>" + Dump.newLine());
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Sub-Archives</td>" + Dump.newLine());
        bw.write("     <td>" + Dump.newLine());
        bw.write("        <table>" + Dump.newLine());
        String outputPath = this.getOutputDirectory().getPath();
        for (Archive subArchive : this.nestableArchive.getSubArchives()) {
            String archiveName = subArchive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            AbstractReport report = null;
            int depth = 1;
            if (subArchive.getType() == 1) {
                if (subArchive.getParentArchive() != null && subArchive.getParentArchive().getParentArchive() != null) {
                    depth = 3;
                } else if (subArchive.getParentArchive() != null) {
                    depth = 2;
                }
                report = new JarReport(subArchive, depth);
            } else if (subArchive.getType() == 2) {
                NestableArchive nestedSubArchive = (NestableArchive)subArchive;
                if (subArchive.getParentArchive() != null) {
                    depth = 2;
                }
                report = new WarReport(nestedSubArchive, 2);
            }
            if (archiveName.contains("WEB-INF/classes")) continue;
            report.generate(outputPath);
            bw.write("        <tr>" + Dump.newLine());
            bw.write("           <td><a href=\"./" + extension + "/" + archiveName + ".html\">" + archiveName + "</a></td>" + Dump.newLine());
            bw.write("        </tr>" + Dump.newLine());
        }
        bw.write("        </table>" + Dump.newLine());
        bw.write("     </td>" + Dump.newLine());
        bw.write("  </tr>");
        bw.write("</table>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>" + this.nestableArchive.getName() + "</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }
}

