/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.ClassesArchive;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

public class GraphvizReport
extends CLSReport {
    private static final String NAME = "Graphical dependencies";
    private static final String DIRECTORY = "graphviz";
    private boolean enableDot = true;
    private String graphvizDot = "dot";

    public GraphvizReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    public void setConfig(Properties config) {
        this.enableDot = Boolean.valueOf(config.getProperty("enableDot", "true"));
        this.graphvizDot = config.getProperty("graphvizDot", "dot");
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Archives</th>" + Dump.newLine());
        bw.write("     <th>Packages</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        FileWriter alldotfw = new FileWriter(this.getOutputDirectory().getAbsolutePath() + File.separator + "dependencies.dot");
        BufferedWriter alldotw = new BufferedWriter(alldotfw, 8192);
        alldotw.write("digraph dependencies {" + Dump.newLine());
        alldotw.write("  node [shape = box, fontsize=10.0];" + Dump.newLine());
        boolean odd = true;
        boolean hasDot = this.testDot();
        for (Archive archive : this.archives) {
            BufferedWriter dotw;
            FileWriter dotfw;
            String dotName;
            File doutput;
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archiveName + "</a></td>" + Dump.newLine());
            bw.write("     <td>");
            TreeSet<String> result = new TreeSet<String>();
            for (String require : this.getRequires(archive)) {
                boolean found = false;
                Iterator ait = this.archives.iterator();
                while (!found && ait.hasNext()) {
                    Archive a = (Archive)ait.next();
                    if (!a.doesProvide(require) || this.getCLS() != null && !this.getCLS().isVisible(archive, a)) continue;
                    result.add(a.getName());
                    found = true;
                }
            }
            if (result.size() == 0) {
                bw.write("&nbsp;");
            } else {
                bw.write("<a href=\"" + archiveName + "/" + archiveName + ".dot\">.dot</a>");
                if (hasDot) {
                    bw.write("&nbsp;");
                    bw.write("<a href=\"" + archiveName + "/" + archiveName + ".png\">.png</a>");
                }
                doutput = new File(this.getOutputDirectory(), archiveName);
                doutput.mkdirs();
                dotName = doutput.getAbsolutePath() + File.separator + archiveName + ".dot";
                String pngName = doutput.getAbsolutePath() + File.separator + archiveName + ".png";
                dotfw = new FileWriter(dotName);
                dotw = new BufferedWriter(dotfw, 8192);
                dotw.write("digraph " + this.dotName(archiveName) + "_dependencies {" + Dump.newLine());
                dotw.write("  node [shape = box, fontsize=10.0];" + Dump.newLine());
                for (String string : result) {
                    alldotw.write("  " + this.dotName(archiveName) + " -> " + this.dotName(string) + ";" + Dump.newLine());
                    dotw.write("  " + this.dotName(archiveName) + " -> " + this.dotName(string) + ";" + Dump.newLine());
                }
                dotw.write("}" + Dump.newLine());
                dotw.flush();
                dotw.close();
                if (this.enableDot && hasDot) {
                    this.generatePicture(dotName, pngName, doutput);
                }
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("     <td>");
            if (archive.getPackageDependencies().size() == 0) {
                bw.write("&nbsp;");
            } else {
                bw.write("<a href=\"" + archiveName + "/" + archiveName + "-package.dot\">.dot</a>");
                if (hasDot) {
                    bw.write("&nbsp;");
                    bw.write("<a href=\"" + archiveName + "/" + archiveName + "-package.png\">.png</a>");
                }
                doutput = new File(this.getOutputDirectory(), archiveName);
                doutput.mkdirs();
                dotName = doutput.getAbsolutePath() + File.separator + archiveName + "-package.dot";
                String pngName = doutput.getAbsolutePath() + File.separator + archiveName + "-package.png";
                dotfw = new FileWriter(dotName);
                dotw = new BufferedWriter(dotfw, 8192);
                dotw.write("digraph " + this.dotName(archiveName) + "_package_dependencies {" + Dump.newLine());
                dotw.write("  node [shape = box, fontsize=10.0];" + Dump.newLine());
                for (Map.Entry entry : archive.getPackageDependencies().entrySet()) {
                    String pkg = this.dotName((String)entry.getKey());
                    SortedSet deps = (SortedSet)entry.getValue();
                    for (String dep : deps) {
                        dotw.write("  " + pkg + " -> " + this.dotName(dep) + ";" + Dump.newLine());
                    }
                }
                dotw.write("}" + Dump.newLine());
                dotw.flush();
                dotw.close();
                if (this.enableDot && hasDot) {
                    this.generatePicture(dotName, pngName, doutput);
                }
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        alldotw.write("}" + Dump.newLine());
        alldotw.flush();
        alldotw.close();
        bw.write("</table>" + Dump.newLine());
    }

    private SortedSet<String> getRequires(Archive archive) {
        TreeSet<String> requires = new TreeSet<String>();
        if (archive instanceof NestableArchive) {
            NestableArchive nestableArchive = (NestableArchive)archive;
            List<Archive> subArchives = nestableArchive.getSubArchives();
            for (Archive sa : subArchives) {
                requires.addAll(this.getRequires(sa));
            }
            requires.addAll(nestableArchive.getRequires());
        } else if (!(archive instanceof ClassesArchive)) {
            requires.addAll(archive.getRequires());
        }
        return requires;
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Graphical dependencies</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
        bw.write("<a href=\"dependencies.dot\">All dependencies</a>");
        bw.write("<p>" + Dump.newLine());
    }

    private String dotName(String name) {
        int idx = name.indexOf(".jar");
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        return name.replace('-', '_').replace('.', '_');
    }

    private boolean testDot() {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb = pb.command(this.graphvizDot, "-V");
            Process proc = pb.redirectErrorStream(true).start();
            proc.waitFor();
            return proc.exitValue() == 0;
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean generatePicture(String dotName, String pngName, File directory) {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb = pb.command(this.graphvizDot, "-Tpng", dotName, "-o", pngName);
            pb = pb.directory(directory);
            Process proc = pb.redirectErrorStream(true).start();
            BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            proc.waitFor();
            return proc.exitValue() == 0;
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        return false;
    }
}

