/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;

public abstract class NestableArchive
extends Archive {
    static final long serialVersionUID = -9197985968607581451L;
    protected List<Archive> subArchives;

    public NestableArchive(int type, String name, int version, List<String> manifest, List<String> sign, SortedSet<String> requires, SortedMap<String, Long> provides, SortedMap<String, SortedSet<String>> classDependencies, SortedMap<String, SortedSet<String>> packageDependencies, SortedMap<String, SortedSet<String>> blacklistedDependencies, Location location) {
        super(type, name, version, manifest, sign, requires, provides, classDependencies, packageDependencies, blacklistedDependencies, location);
        this.subArchives = null;
    }

    public NestableArchive(int type, String name, int version, List<String> manifest, List<String> sign, SortedSet<String> requires, SortedMap<String, Long> provides, SortedMap<String, SortedSet<String>> classDependencies, SortedMap<String, SortedSet<String>> packageDependencies, SortedMap<String, SortedSet<String>> blacklistedDependencies, Location location, List<Archive> subArchives) {
        super(type, name, version, manifest, sign, requires, provides, classDependencies, packageDependencies, blacklistedDependencies, location);
        this.subArchives = subArchives;
        this.addParentArchive(subArchives);
    }

    public List<Archive> getSubArchives() {
        return this.subArchives != null ? this.subArchives : Collections.unmodifiableList(new ArrayList(1));
    }

    public void addSubArchive(Archive value) {
        if (value != null) {
            if (this.subArchives == null) {
                this.subArchives = new ArrayList<Archive>(1);
            }
            this.subArchives.add(value);
        }
    }

    private void addParentArchive(List<Archive> subArchives) {
        if (subArchives != null) {
            for (Archive archive : subArchives) {
                archive.setParentArchive(this);
            }
        }
    }
}

