/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.middleware.tattletale.reports;

import com.redhat.gss.middleware.tattletale.reports.ReportWithParameters;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.zip.DeflaterOutputStream;
import org.jboss.tattletale.core.Archive;

public class MarshalledReport
implements ReportWithParameters {
    private static final String NAME = "Marshalled Report";
    private static final String ID = "marshalledReport";
    private static final String DIRECTORY = "marshalled-report";
    private static final int STATUS = 0;
    private static final int SEVERITY = 0;
    protected SortedSet<Archive> archives;
    private File outputDirectory;

    public MarshalledReport() {
        System.out.println("MarshalledReport()");
    }

    public MarshalledReport(String id, int severity, String name, String directory) {
        System.out.println("MarshalledReport(" + id + "," + severity + ", " + name + ", " + directory + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshal(Object object, File filename) {
        System.out.println("marhsal " + object.getClass().getName() + " to " + filename);
        FileOutputStream fos = null;
        DeflaterOutputStream dos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(filename);
            dos = new DeflaterOutputStream(fos);
            out = new ObjectOutputStream(dos);
            out.writeObject(object);
        }
        catch (IOException ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                MarshalledReport.closeAndEat(out, dos, fos);
                throw throwable;
            }
            MarshalledReport.closeAndEat(out, dos, fos);
        }
        MarshalledReport.closeAndEat(out, dos, fos);
    }

    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public void generate(String rootOutputDirectory) {
        this.createOutputDir(rootOutputDirectory);
        this.marshal(this.archives, new File(this.outputDirectory, "archives.ser.deflate"));
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public int getSeverity() {
        return 0;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public String getDirectory() {
        return DIRECTORY;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getFilter() {
        return null;
    }

    @Override
    public File getOutputDirectory() {
        return null;
    }

    @Override
    public String getIndexName() {
        return null;
    }

    @Override
    public void setFilter(String paramString) {
    }

    void createOutputDir(String outputDirectory) {
        this.outputDirectory = new File(outputDirectory, this.getDirectory());
        this.outputDirectory.mkdirs();
    }

    public BufferedWriter getBufferedWriter(String filename) throws IOException {
        FileWriter fw = new FileWriter(this.getOutputDirectory().getAbsolutePath() + File.separator + filename);
        return new BufferedWriter(fw, 8192);
    }

    @Override
    public void setCLS(String classloaderStructure) {
    }

    @Override
    public void setKnown(List known) {
    }

    @Override
    public void setArchives(SortedSet<Archive> archives) {
        this.archives = archives;
    }

    @Override
    public void setConfig(Properties config) {
    }

    @Override
    public void setGlobalProvides(SortedMap gProvides) {
    }

    private static void closeAndEat(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

