/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.middleware.tattletale.reports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.jboss.tattletale.profiles.AbstractProfile;
import org.jboss.tattletale.profiles.Profile;

public abstract class AbstractExtendedProfile
extends AbstractProfile
implements Profile {
    protected Map<String, ArrayList<String>> classMap = new HashMap<String, ArrayList<String>>();

    public AbstractExtendedProfile(String classSet, int type, String name, int version, String location) {
        this(type, name, version, location);
        this.loadProfile(classSet);
    }

    public AbstractExtendedProfile(int type, String name, int version, String location) {
        super(type, name, version, location);
    }

    public List<String> getLocationProvided(String clz) {
        return this.classMap.get(clz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadProfile(String resourceFile) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(resourceFile);
            GZIPInputStream gis = new GZIPInputStream(is);
            InputStreamReader isr = new InputStreamReader(gis);
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            String currentLocation = "<not initialized>";
            while (s != null) {
                if (s.endsWith("=")) {
                    currentLocation = s.substring(0, s.length() - 1);
                } else {
                    ArrayList<String> tmpList = this.classMap.get(s);
                    if (tmpList == null) {
                        tmpList = new ArrayList(1);
                    }
                    tmpList.add(currentLocation);
                    this.classMap.put(s, tmpList);
                }
                s = br.readLine();
            }
            this.classSet = this.classMap.keySet();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

