/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.util.SecurityActions;
import org.jboss.forge.furnace.util.Streams;

public class ClassLoaders {
    private static final Logger log = Logger.getLogger(ClassLoaders.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeIn(ClassLoader loader, Callable<T> task) throws Exception {
        if (task == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClassLoader [" + loader + "] task began.");
        }
        ClassLoader original = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(loader);
            T t = task.call();
            return t;
        }
        finally {
            SecurityActions.setContextClassLoader(original);
            if (log.isLoggable(Level.FINE)) {
                log.fine("ClassLoader [" + loader + "] task ended.");
            }
        }
    }

    public static void executeIn(ClassLoader loader, Runnable task) throws Exception {
        if (task == null) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClassLoader [" + loader + "] task began.");
        }
        ClassLoader original = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(loader);
            task.run();
        }
        finally {
            SecurityActions.setContextClassLoader(original);
            if (log.isLoggable(Level.FINE)) {
                log.fine("ClassLoader [" + loader + "] task ended.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeIn(URL[] urls, Callable<T> callable) throws Exception {
        T t;
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader newClassLoader = null;
        try {
            newClassLoader = new URLClassLoader(urls, savedClassLoader);
            t = ClassLoaders.executeIn((ClassLoader)newClassLoader, callable);
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(newClassLoader);
            throw throwable;
        }
        Streams.closeQuietly(newClassLoader);
        return t;
    }

    public static boolean containsClass(ClassLoader loader, Class<?> type) {
        if (loader == null) {
            throw new IllegalArgumentException("Class loader to inspect must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Class to find must not be null.");
        }
        try {
            return loader.loadClass(type.getName()) == type;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }

    public static boolean containsClass(ClassLoader loader, String type) {
        if (loader == null) {
            throw new IllegalArgumentException("Class loader to inspect must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Class to find must not be null.");
        }
        try {
            loader.loadClass(type);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }

    public static Class<?> loadClass(ClassLoader loader, String typeName) {
        if (loader == null) {
            throw new IllegalArgumentException("Class loader to inspect must not be null.");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Class name to find must not be null.");
        }
        try {
            return loader.loadClass(typeName);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new ContainerException("Could not locate class [" + typeName + "] in Loader [" + loader + "]", e);
        }
    }

    public static Class<?> loadClass(ClassLoader loader, Class<?> type) {
        if (loader == null) {
            throw new IllegalArgumentException("Class loader to inspect must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Class to find must not be null.");
        }
        try {
            return loader.loadClass(type.getName());
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new ContainerException("Could not locate class [" + type.getName() + "] in Loader [" + loader + "]", e);
        }
    }

    public static boolean ownsClass(ClassLoader loader, Class<?> type) {
        if (loader == null) {
            throw new IllegalArgumentException("Class loader to inspect must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Class to find must not be null.");
        }
        return loader.equals(type.getClassLoader());
    }

    public static Throwable getClassLoadingExceptionFor(ClassLoader loader, String typeName) {
        try {
            loader.loadClass(typeName);
            return null;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return e;
        }
    }
}

