/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.proxy;

import org.jboss.forge.furnace.util.Assert;

class Arrays {
    Arrays() {
    }

    @SafeVarargs
    public static <ELEMENTTYPE> ELEMENTTYPE[] append(ELEMENTTYPE[] array, ELEMENTTYPE ... elements) {
        int length = array.length;
        array = java.util.Arrays.copyOf(array, length + elements.length);
        System.arraycopy(elements, 0, array, length, elements.length);
        return array;
    }

    @SafeVarargs
    public static <ELEMENTTYPE> ELEMENTTYPE[] prepend(ELEMENTTYPE[] array, ELEMENTTYPE ... elements) {
        int length = array.length;
        array = java.util.Arrays.copyOf(array, length + elements.length);
        System.arraycopy(array, 0, array, elements.length, length);
        System.arraycopy(elements, 0, array, 0, elements.length);
        return array;
    }

    public static <ELEMENTTYPE> ELEMENTTYPE[] copy(ELEMENTTYPE[] source, ELEMENTTYPE[] target) {
        Assert.isTrue(source.length == target.length, "Source and destination arrays must be of the same length.");
        System.arraycopy(source, 0, target, 0, source.length);
        return target;
    }

    public static <ELEMENTTYPE> ELEMENTTYPE[] shiftLeft(ELEMENTTYPE[] source, ELEMENTTYPE[] target) {
        Assert.isTrue(source.length > 0, "Source array length cannot be zero.");
        Assert.isTrue(source.length - 1 == target.length, "Destination array must be one element shorter than the source array.");
        System.arraycopy(source, 1, target, 0, target.length);
        return target;
    }

    public static <ELEMENTTYPE> boolean contains(ELEMENTTYPE[] array, ELEMENTTYPE value) {
        return Arrays.indexOf(array, value) >= 0;
    }

    public static <ELEMENTTYPE> int indexOf(ELEMENTTYPE[] array, ELEMENTTYPE value) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            ELEMENTTYPE element = array[i];
            if (element != value) continue;
            return i;
        }
        return -1;
    }

    public static <ELEMENTTYPE> ELEMENTTYPE[] removeElementAtIndex(ELEMENTTYPE[] array, int index) {
        Assert.isTrue(array.length > 0, "Cannot remove an element from an already empty array.");
        ELEMENTTYPE[] result = java.util.Arrays.copyOf(array, array.length - 1);
        if (result.length > 0 && array.length + 1 != index && index != result.length) {
            System.arraycopy(array, index + 1, result, index, array.length - (array.length - index));
        }
        return result;
    }
}

