/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.KShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.KShortestSimplePathsIterator;
import org.jgrapht.alg.shortestpath.PathValidator;
import org.jgrapht.alg.shortestpath.RankingPathElementList;
import org.jgrapht.graph.GraphWalk;

public class KShortestSimplePaths<V, E>
implements KShortestPathAlgorithm<V, E> {
    private Graph<V, E> graph;
    private int nMaxHops;
    private PathValidator<V, E> pathValidator;

    public KShortestSimplePaths(Graph<V, E> graph) {
        this(graph, graph.vertexSet().size() - 1, null);
    }

    public KShortestSimplePaths(Graph<V, E> graph, PathValidator<V, E> pathValidator) {
        this(graph, graph.vertexSet().size() - 1, pathValidator);
    }

    public KShortestSimplePaths(Graph<V, E> graph, int nMaxHops) {
        this(graph, nMaxHops, null);
    }

    public KShortestSimplePaths(Graph<V, E> graph, int nMaxHops, PathValidator<V, E> pathValidator) {
        this.graph = Objects.requireNonNull(graph, "graph is null");
        this.nMaxHops = nMaxHops;
        if (nMaxHops <= 0) {
            throw new IllegalArgumentException("Max number of hops must be positive");
        }
        this.pathValidator = pathValidator;
    }

    @Override
    public List<GraphPath<V, E>> getPaths(V startVertex, V endVertex, int k) {
        Objects.requireNonNull(startVertex, "Start vertex cannot be null");
        Objects.requireNonNull(endVertex, "End vertex cannot be null");
        if (endVertex.equals(startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.graph.containsVertex(startVertex)) {
            throw new IllegalArgumentException("Graph must contain the start vertex!");
        }
        if (!this.graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("Graph must contain the end vertex!");
        }
        if (k <= 0) {
            throw new IllegalArgumentException("Number of paths must be positive");
        }
        KShortestSimplePathsIterator<V, E> iter = new KShortestSimplePathsIterator<V, E>(this.graph, startVertex, endVertex, k, this.pathValidator);
        for (int passNumber = 1; passNumber <= this.nMaxHops && iter.hasNext(); ++passNumber) {
            iter.next();
        }
        RankingPathElementList<V, E> pathElements = iter.getPathElements(endVertex);
        if (pathElements == null) {
            return Collections.emptyList();
        }
        return pathElements.stream().map(e -> new GraphWalk<Object, E>(this.graph, startVertex, e.getVertex(), null, e.createEdgeListPath(), e.getWeight())).collect(Collectors.toCollection(ArrayList::new));
    }
}

