/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.impl.addons.LazyDirtyChecker;

public class FileSystemDirtyChecker
extends LazyDirtyChecker {
    private static Logger logger = Logger.getLogger(FileSystemDirtyChecker.class.getName());
    private final File directory;
    private WatchService watcher;

    public FileSystemDirtyChecker(File directory) {
        this.directory = directory;
    }

    @Override
    protected void init() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "File monitoring could not be started.", e);
            return;
        }
        try {
            if (this.directory.exists() && this.directory.isDirectory() || this.directory.mkdirs()) {
                this.directory.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
                logger.log(Level.FINE, "Monitoring repository [" + this.directory.toString() + "] for file changes.");
            } else {
                logger.log(Level.WARNING, "Cannot monitor repository [" + this.directory + "] for changes because it is not a directory.");
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not monitor repository [" + this.directory.toString() + "] for file changes.", e);
        }
    }

    @Override
    protected boolean isDirtyInternal() {
        if (this.watcher == null) {
            return false;
        }
        boolean dirty = false;
        WatchKey key = this.watcher.poll();
        while (key != null) {
            List<WatchEvent<?>> events = key.pollEvents();
            if (!events.isEmpty()) {
                logger.log(Level.FINE, "Detected changes in repository [" + events.iterator().next().context() + "].");
                dirty = true;
            }
            key = this.watcher.poll();
        }
        return dirty;
    }

    @Override
    public void close() throws Exception {
        if (this.watcher != null) {
            this.watcher.close();
        }
    }
}

