/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.websphere;

import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.LinkService;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverEjbConfigurationXmlRuleProvider.class}, perform="Discover WebSphere EJB XML Files")
public class ResolveWebSphereEjbBindingXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveWebSphereEjbBindingXmlRuleProvider.class.getName());

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"ibm-ejb-jar-bnd.xmi").withProperty("rootTagName", (Object)"EJBJarBinding");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        GraphContext graphContext = event.getGraphContext();
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(graphContext);
        XmlFileService xmlFileService = new XmlFileService(graphContext);
        JNDIResourceService jndiResourceService = new JNDIResourceService(graphContext);
        JmsDestinationService jmsDestinationService = new JmsDestinationService(graphContext);
        GraphService ejbSessionBeanService = new GraphService(graphContext, EjbSessionBeanModel.class);
        GraphService mdbService = new GraphService(graphContext, EjbMessageDrivenModel.class);
        ClassificationService classificationService = new ClassificationService(graphContext);
        ClassificationModel classification = classificationService.attachClassification(event, context, (FileModel)payload, "mandatory", "WebSphere EJB binding descriptor (ibm-ejb-jar-bnd)", "WebSphere Enterprise Java Bean Binding XML Descriptor describes how to bind enterprise beans or its resources. For instance EJB JNDI or data sources for entity beans. \n Red Hat JBoss EAP uses standard Java EE annotations or deployment descriptors like `ejb-jar.xml` or `jboss-ejb3.xml`. Please read JBoss EAP 7 documentation.");
        classification.setEffort(3);
        IssueCategoryModel cat = IssueCategoryRegistry.loadFromGraph((GraphContext)graphContext, (String)"mandatory");
        classification.setIssueCategory(cat);
        LinkService linkService = new LinkService(graphContext);
        LinkModel link = (LinkModel)linkService.create();
        link.setDescription("Websphere AS - Application bindings");
        link.setLink("https://www.ibm.com/support/knowledgecenter/en/SSAW57_8.0.0/com.ibm.websphere.nd.doc/info/ae/ae/crun_app_bindings.html#crun_app_bindings__timbindings");
        classificationService.attachLink(classification, link);
        LinkModel eap7Link = (LinkModel)linkService.create();
        eap7Link.setDescription("EAP 7 - Developing EJB Applications");
        eap7Link.setLink("https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.0/html-single/developing_ejb_applications/");
        classificationService.attachLink(classification, eap7Link);
        TechnologyTagService technologyTagService = new TechnologyTagService(graphContext);
        technologyTagService.addTagToFileModel((FileModel)payload, "WebSphere EJB", TechnologyTagLevel.IMPORTANT);
        Document doc = xmlFileService.loadDocumentQuiet(event, context, payload);
        if (doc == null) {
            return;
        }
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(graphContext);
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "ejb-jar.xml");
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)graphContext, (ProjectModel)payload.getProjectModel());
        for (Element resourceRef : JOOX.$((Document)doc).find("ejbBindings").get()) {
            String href = JOOX.$((Element)resourceRef).child("enterpriseBean").attr("href");
            String resourceId = StringUtils.substringAfterLast((String)href, (String)"ejb-jar.xml#");
            String jndiLocation = JOOX.$((Element)resourceRef).attr("jndiName");
            String type = JOOX.$((Element)resourceRef).child("enterpriseBean").attr("type");
            LOG.info("enterpriseBean type: " + type);
            if (!StringUtils.isNotBlank((CharSequence)jndiLocation) || !StringUtils.isNotBlank((CharSequence)resourceId)) continue;
            JNDIResourceModel resource = jndiResourceService.createUnique(applications, jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceId);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("referenceId", resourceId)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
            for (EjbSessionBeanModel ejb : ejbSessionBeanService.findAllByProperty("ejbId", (Object)resourceId)) {
                ejb.setGlobalJndiReference(resource);
            }
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "bindingResourceRef");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejbRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "bindingEjbRef");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("messageDestinationRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "bindingMessageDestinationRef");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("messageDestinationRefBindings").get()) {
            String jndiLocation = JOOX.$((Element)resourceRef).attr("jndiName");
            String mdbRef = JOOX.$((Element)resourceRef).siblings("enterpriseBean").attr("href");
            String mdbId = StringUtils.substringAfterLast((String)mdbRef, (String)"ejb-jar.xml#");
            if (!StringUtils.isNotBlank((CharSequence)mdbId)) continue;
            for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbId", (Object)mdbId)) {
                String destination = jndiLocation;
                if (!StringUtils.isNotBlank((CharSequence)destination)) continue;
                JmsDestinationModel jndiRef = jmsDestinationService.createUnique(applications, destination);
                mdb.setDestination(jndiRef);
            }
        }
    }

    private void processBinding(EnvironmentReferenceService envRefService, JNDIResourceService jndiResourceService, Set<ProjectModel> applications, Element resourceRef, String tagName) {
        String href = JOOX.$((Element)resourceRef).child(tagName).attr("href");
        String resourceId = StringUtils.substringAfterLast((String)href, (String)"ejb-jar.xml#");
        String jndiLocation = JOOX.$((Element)resourceRef).attr("jndiName");
        if (StringUtils.isNotBlank((CharSequence)jndiLocation) && StringUtils.isNotBlank((CharSequence)resourceId)) {
            JNDIResourceModel resource = jndiResourceService.createUnique(applications, jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceId);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("referenceId", resourceId)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
    }
}

