/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.model;

import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.JavaHandler;
import org.jboss.windup.graph.MapInAdjacentProperties;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.model.HasApplications;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.jboss.windup.rules.apps.javaee.model.JPAConfigurationFileModel;

@TypeValue(value="JPAPersistenceUnitModel")
public interface JPAPersistenceUnitModel
extends WindupVertexFrame,
HasApplications {
    public static final String TYPE = "JPAPersistenceUnitModel";
    public static final String DATASOURCE = "datasource";
    public static final String NAME = "JPAPersistenceUnitModel-name";
    public static final String APPLICATION = "application";

    @Adjacency(label="application", direction=Direction.OUT)
    public ProjectModel getApplication();

    @Adjacency(label="application", direction=Direction.OUT)
    public void setApplication(ProjectModel var1);

    @Property(value="JPAPersistenceUnitModel-name")
    public String getName();

    @Property(value="JPAPersistenceUnitModel-name")
    public void setName(String var1);

    @Adjacency(label="datasource", direction=Direction.OUT)
    public List<DataSourceModel> getDataSources();

    @Adjacency(label="datasource", direction=Direction.OUT)
    public void addDataSource(DataSourceModel var1);

    @Adjacency(label="jpaPersistenceUnit", direction=Direction.IN)
    public JPAConfigurationFileModel getJPAConfigurationFileModel();

    @MapInAdjacentProperties(label="persistenceUnitProperties")
    public Map<String, String> getProperties();

    @MapInAdjacentProperties(label="persistenceUnitProperties")
    public void setProperties(Map<String, String> var1);

    @JavaHandler(handler=Impl.class)
    public List<ProjectModel> getApplications();

    @JavaHandler(handler=Impl.class)
    public boolean belongsToProject(ProjectModel var1);

    public static class Impl {
        public List<ProjectModel> getApplications(JPAPersistenceUnitModel model) {
            return model.getJPAConfigurationFileModel().getApplications();
        }

        public boolean belongsToProject(JPAPersistenceUnitModel model, ProjectModel projectModel) {
            return model.getJPAConfigurationFileModel().belongsToProject(projectModel);
        }
    }
}

