/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.reporting.model.TechnologyUsageStatisticsModel;
import org.jboss.windup.rules.apps.javaee.TechnologyUsageStatisticsService;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class TechnologyUsageStatisticsModelExists
extends GraphCondition {
    private String technologyName;
    private Set<String> expectedTags;
    private int expectedCount;

    public TechnologyUsageStatisticsModelExists() {
    }

    public TechnologyUsageStatisticsModelExists(String technologyName, int expectedCount, Set<String> expectedTags) {
        this.technologyName = technologyName;
        this.expectedCount = expectedCount;
        this.expectedTags = expectedTags;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        TechnologyUsageStatisticsService service = new TechnologyUsageStatisticsService(event.getGraphContext());
        Iterable models = service.findAllByProperty("stats.name", this.technologyName);
        boolean result = false;
        for (TechnologyUsageStatisticsModel model : models) {
            if (!this.matchesExpectations(model)) continue;
            result = true;
        }
        return result;
    }

    private boolean matchesExpectations(TechnologyUsageStatisticsModel model) {
        if (!StringUtils.equals((CharSequence)this.technologyName, (CharSequence)model.getName())) {
            return false;
        }
        if (this.expectedCount != model.getOccurrenceCount()) {
            return false;
        }
        return this.expectedTags.containsAll(model.getTags());
    }

    public String getTechnologyName() {
        return this.technologyName;
    }

    public Set<String> getExpectedTags() {
        return this.expectedTags;
    }

    public int getExpectedCount() {
        return this.expectedCount;
    }
}

