/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.javaee.TechnologyIdentified;
import org.jboss.windup.rules.apps.javaee.TechnologyIdentifiedWithCount;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="technology-identified", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class TechnologyIdentifiedHandler
implements ElementHandler<TechnologyIdentified> {
    public static final String TAG_NAME = "technology-identified";
    public static final String NAME = "name";
    public static final String TAG = "tag";
    public static final String NUMBER_FOUND = "number-found";
    private static final Logger LOG = Logger.getLogger(TechnologyIdentified.class.getName());

    public TechnologyIdentified processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String technologyName = JOOX.$((Element)element).attr(NAME);
        if (StringUtils.isBlank((CharSequence)technologyName)) {
            throw new WindupException("Error, 'technology-identified' element must have a non-empty 'name' attribute or element");
        }
        int count = 1;
        String countStr = JOOX.$((Element)element).attr(NUMBER_FOUND);
        if (StringUtils.isNotBlank((CharSequence)countStr)) {
            countStr = countStr.trim();
            try {
                count = Integer.parseInt(countStr);
            }
            catch (Exception e) {
                LOG.warning("Could not parse count string '" + countStr + "' for technology identifier: " + technologyName);
            }
        }
        HashSet<String> tags = new HashSet<String>();
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            String tag;
            if (!child.getNodeName().equals(TAG) || StringUtils.isBlank((CharSequence)(tag = JOOX.$((Element)child).attr(NAME)))) continue;
            tags.add(tag);
        }
        TechnologyIdentifiedWithCount withCount = TechnologyIdentified.named(technologyName).numberFound(count);
        tags.forEach(withCount::withTag);
        return (TechnologyIdentified)withCount;
    }
}

