/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.model.FileReferenceModel;
import org.jboss.windup.graph.model.HasApplications;
import org.jboss.windup.graph.model.HasProject;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.TagSetModel;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.jboss.windup.reporting.model.TechnologyUsageStatisticsModel;
import org.jboss.windup.reporting.service.TagSetService;
import org.jboss.windup.rules.apps.javaee.TechnologyIdentifiedWithCount;
import org.jboss.windup.rules.apps.javaee.TechnologyIdentifiedWithName;
import org.jboss.windup.rules.apps.javaee.TechnologyUsageStatisticsService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class TechnologyIdentified
extends AbstractIterationOperation<WindupVertexFrame>
implements TechnologyIdentifiedWithCount,
TechnologyIdentifiedWithName {
    public static final int DEFAULT_COUNT = 1;
    private static Logger LOG = Logging.get(TechnologyIdentified.class);
    private String technologyName;
    private Set<String> tags = new HashSet<String>();
    private int count = 1;

    public TechnologyIdentified(String technologyName) {
        this.technologyName = technologyName;
    }

    public TechnologyIdentified(String variableName, String technologyName) {
        super(variableName);
        this.technologyName = technologyName;
    }

    public static TechnologyIdentifiedWithName named(String technologyName) {
        return new TechnologyIdentified(technologyName);
    }

    @Override
    public TechnologyIdentifiedWithCount numberFound(int count) {
        this.count = count;
        return this;
    }

    @Override
    public TechnologyIdentified withTag(String tag) {
        this.tags.add(tag);
        return this;
    }

    public String getTechnologyName() {
        return this.technologyName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public int getCount() {
        return this.count;
    }

    public void perform(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
        HashSet<ProjectModel> projects = new HashSet<ProjectModel>();
        if (payload instanceof FileReferenceModel) {
            payload = ((FileReferenceModel)payload).getFile();
        }
        if (payload instanceof ClassificationModel) {
            ((ClassificationModel)payload).getFileModels().forEach(fileModel -> projects.add(fileModel.getProjectModel()));
        } else if (payload instanceof HasProject) {
            projects.add(((HasProject)payload).getProjectModel());
        } else if (payload instanceof HasApplications) {
            List rootProjectModels = ((HasApplications)payload).getApplications();
            for (ProjectModel projectModel : rootProjectModels) {
                projects.add(projectModel);
            }
        } else if (payload instanceof TechnologyTagModel) {
            ((TechnologyTagModel)payload).getFileModels().forEach(fileModel -> projects.add(fileModel.getProjectModel()));
        } else {
            LOG.warning("Unrecognized payload for TechnologyIdentified. Payload must be instance of BelongsToProject.");
            LOG.warning(payload.toPrettyString());
            return;
        }
        for (ProjectModel project : projects) {
            TechnologyUsageStatisticsService service = new TechnologyUsageStatisticsService(event.getGraphContext());
            TechnologyUsageStatisticsModel stats = service.getOrCreate(project, this.technologyName);
            stats.setOccurrenceCount(stats.getOccurrenceCount() + this.count);
            TagSetModel tagModel = stats.getTagModel();
            if (tagModel == null) {
                tagModel = new TagSetService(event.getGraphContext()).getOrCreate(event, this.tags);
                stats.setTagModel(tagModel);
            }
            if (tagModel.getTags().equals(this.tags)) continue;
            HashSet<String> newSet = new HashSet<String>(tagModel.getTags());
            newSet.addAll(this.tags);
            tagModel = new TagSetService(event.getGraphContext()).getOrCreate(event, this.tags);
            stats.setTagModel(tagModel);
        }
    }
}

