/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;

public class Logger {
    private File logFilePath;
    private PrintStream logFileStream;
    private final byte logLevel;
    private long logFileSize;
    public static final byte ERROR = 1;
    public static final byte WARNING = 2;
    public static final byte INFORMATIONAL = 3;
    public static final byte DEBUG = 4;
    private static final int LOG_FILE_MAX_SIZE = 1000000;
    private Object[] date;
    MessageFormat formatter = new MessageFormat("{0,date} {0,time}");

    public Logger(File logFilePath, byte logLevel) throws IOException {
        if (logFilePath.exists()) {
            logFilePath.renameTo(new File(logFilePath.getAbsolutePath() + "_" + System.currentTimeMillis()));
        }
        this.logFilePath = logFilePath;
        this.logFileStream = new PrintStream(new FileOutputStream(logFilePath), true);
        this.logLevel = logLevel;
        this.date = new Object[1];
        this.date[0] = new Date();
    }

    private void rotateLogFile() throws FileNotFoundException {
        this.logFileStream.close();
        this.logFilePath.renameTo(new File(this.logFilePath.getAbsolutePath() + "_" + System.currentTimeMillis()));
        this.logFileSize = 0L;
        this.logFileStream = new PrintStream(new FileOutputStream(this.logFilePath), true);
    }

    public void logError(String msg) {
        if (this.logLevel >= 1) {
            this.writeMessageToLogFile(msg);
        }
    }

    public void logWarning(String msg) {
        if (this.logLevel >= 2) {
            this.writeMessageToLogFile(msg);
        }
    }

    public void logInfo(String msg) {
        if (this.logLevel >= 3) {
            this.writeMessageToLogFile(msg);
        }
    }

    public void logDebug(String msg) {
        if (this.logLevel >= 4) {
            this.writeMessageToLogFile(msg);
        }
    }

    public void logThrowable(Throwable t, byte atLogLevel) {
        if (this.logLevel >= atLogLevel) {
            this.writeMessageToLogFile(t.getMessage());
            t.printStackTrace(this.logFileStream);
            this.logFileStream.println();
            this.logFileStream.flush();
            this.setLogFileSize(this.logFilePath.length());
        }
    }

    public void release() throws IOException {
        this.logFileStream.close();
    }

    private void writeMessageToLogFile(String msg) {
        StringBuffer sb = new StringBuffer();
        ((Date)this.date[0]).setTime(System.currentTimeMillis());
        this.formatter.format(this.date, sb, (FieldPosition)null);
        String logMsg = sb + " : " + msg + "\n\n";
        this.logFileStream.print(logMsg);
        this.logFileStream.flush();
        this.setLogFileSize(this.logFileSize + (long)logMsg.length());
    }

    private void setLogFileSize(long newLogFileSize) {
        this.logFileSize = newLogFileSize;
        if (this.logFileSize >= 1000000L) {
            try {
                this.rotateLogFile();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
        }
    }
}

