/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.transaction.xa.Xid;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.ResourceDependencyGraph;

public class TransactionInformation
implements Xid,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] gid;
    private final byte[] bqual;
    private final int formatId;
    private int numOwnedExclusiveLocks = 0;
    private volatile transient ResourceDependencyGraph.Node nodeInResourceDependencyGraph = null;
    private transient NativeSession owningSession;

    TransactionInformation(ByteBuffer buffer) {
        byte gidLength = buffer.get();
        byte bqualLength = buffer.get();
        this.formatId = buffer.getInt();
        this.gid = new byte[gidLength];
        this.bqual = new byte[bqualLength];
        buffer.get(this.gid);
        buffer.get(this.bqual);
    }

    public TransactionInformation(Xid xid) {
        this.gid = xid.getGlobalTransactionId();
        this.bqual = xid.getBranchQualifier();
        this.formatId = xid.getFormatId();
    }

    public TransactionInformation(byte[] gid, byte[] bqual, int formatId) {
        this.gid = gid;
        this.bqual = bqual;
        this.formatId = formatId;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TransactionInformation) {
            int i;
            TransactionInformation xid = (TransactionInformation)obj;
            if (xid.getFormatId() != this.formatId) {
                return false;
            }
            byte[] temp = xid.getGlobalTransactionId();
            for (i = 0; i < temp.length; ++i) {
                if (i < this.gid.length && temp[i] == this.gid[i]) continue;
                return false;
            }
            temp = xid.getBranchQualifier();
            for (i = 0; i < temp.length; ++i) {
                if (i < this.bqual.length && temp[i] == this.bqual[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.gid.length > 0) {
            hashCode += this.gid[0] + this.gid[this.gid.length / 2] + this.gid[this.gid.length - 1];
        }
        if (this.bqual.length > 0) {
            hashCode += this.bqual[0] + this.bqual[this.bqual.length / 2] + this.bqual[this.bqual.length - 1];
        }
        return hashCode;
    }

    public ResourceDependencyGraph.Node getNodeInResourceDependencyGraph() {
        return this.nodeInResourceDependencyGraph;
    }

    public void setNodeInResourceDependencyGraph(ResourceDependencyGraph.Node nodeInResourceDependencyGraph) {
        this.nodeInResourceDependencyGraph = nodeInResourceDependencyGraph;
    }

    public static TransactionInformation getXidInstanceForLocalTransaction(long localTransactionId) {
        ByteBuffer tidBuffer = ByteBuffer.allocate(20);
        tidBuffer.put((byte)8);
        tidBuffer.put((byte)0);
        tidBuffer.putInt(101);
        tidBuffer.putLong(localTransactionId);
        tidBuffer.flip();
        return new TransactionInformation(tidBuffer);
    }

    public byte[] getBytes() {
        ByteBuffer temp = ByteBuffer.allocate(6 + this.gid.length + this.bqual.length);
        temp.put((byte)this.gid.length);
        temp.put((byte)this.bqual.length);
        temp.putInt(this.formatId);
        temp.put(this.gid);
        temp.put(this.bqual);
        byte[] bytes = new byte[temp.capacity()];
        temp.flip();
        temp.get(bytes);
        return bytes;
    }

    public NativeSession getOwningSession() {
        return this.owningSession;
    }

    public void setOwningSession(NativeSession owningSession) {
        this.owningSession = owningSession;
    }

    public int getNumOwnedExclusiveLocks() {
        return this.numOwnedExclusiveLocks;
    }

    public void incrementNumOwnedExclusiveLocks() {
        ++this.numOwnedExclusiveLocks;
    }

    public String toString() {
        return "gid : \t" + this.getHexString(this.gid) + "\n" + "bqual : \t" + this.getHexString(this.bqual) + "\n" + "formatId : \t" + Integer.toHexString(this.formatId);
    }

    private String getHexString(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bs) {
            sb.append(Integer.toHexString(b)).append(" ");
        }
        return sb.toString();
    }
}

