/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.Theme;

public class ThemeProvider {
    private static volatile ThemeProvider instance;
    private final Theme theme;

    private ThemeProvider() {
        block15: {
            try (InputStream input = ThemeProvider.class.getClassLoader().getResourceAsStream("windup-config.properties");){
                if (input == null) {
                    Furnace furnace = SimpleContainer.getFurnace((ClassLoader)ThemeProvider.class.getClassLoader());
                    try (InputStream another = furnace.getRuntimeClassLoader().getResourceAsStream("windup-config.properties");){
                        this.theme = this.load(another);
                        break block15;
                    }
                }
                this.theme = this.load(input);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private Theme load(InputStream input) throws IOException {
        Properties prop = new Properties();
        prop.load(input);
        String topBarTitle = prop.getProperty("distributionTopBarTitle");
        String brandName = prop.getProperty("distributionBrandName");
        String nameAcronym = prop.getProperty("distributionBrandNameAcronym");
        String websiteUrl = prop.getProperty("distributionBrandWebsiteUrl");
        String documentationUrl = prop.getProperty("distributionBrandDocumentationUrl");
        String cliName = prop.getProperty("distributionBrandCliName");
        File cliVersionFile = PathUtil.getWindupHome().resolve("cli-version.txt").toFile();
        String cliVersion = this.getRuntimeAPIVersion();
        if (cliVersionFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(cliVersionFile));){
                cliVersion = br.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Theme(topBarTitle, brandName, nameAcronym, websiteUrl, documentationUrl, cliName, cliVersion, this.getRuntimeAPIVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThemeProvider getInstance() {
        if (instance != null) return instance;
        Class<ThemeProvider> clazz = ThemeProvider.class;
        synchronized (ThemeProvider.class) {
            if (instance != null) return instance;
            instance = new ThemeProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Theme getTheme() {
        return this.theme;
    }

    private String getRuntimeAPIVersion() {
        String version = ThemeProvider.class.getPackage().getImplementationVersion();
        if (version != null) {
            return version;
        }
        return EmptyVersion.getInstance().toString();
    }
}

