/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.subquerycache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.transaction.subquerycache.SubsetSubqueryCache;

public class GuavaSubqueryCache
extends SubsetSubqueryCache {
    private Cache<JointIndexQuery.Subquery, SubsetSubqueryCache.SubqueryResult> guavaCache;

    public GuavaSubqueryCache(int concurrencyLevel, long maximumWeight) {
        this.guavaCache = CacheBuilder.newBuilder().weigher((q, r) -> 2 + r.size()).concurrencyLevel(concurrencyLevel).maximumWeight(maximumWeight).build();
    }

    @Override
    protected SubsetSubqueryCache.SubqueryResult get(JointIndexQuery.Subquery key) {
        return (SubsetSubqueryCache.SubqueryResult)this.guavaCache.getIfPresent((Object)key);
    }

    @Override
    protected void put(JointIndexQuery.Subquery key, SubsetSubqueryCache.SubqueryResult result) {
        this.guavaCache.put((Object)key, (Object)result);
    }

    @Override
    public synchronized void close() {
        this.guavaCache.invalidateAll();
        this.guavaCache.cleanUp();
    }
}

