/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.AdjacentVertexOptimizerStrategy;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class AdjacentVertexHasIdOptimizerStrategy
extends AdjacentVertexOptimizerStrategy<HasStep<?>> {
    private static final AdjacentVertexHasIdOptimizerStrategy INSTANCE = new AdjacentVertexHasIdOptimizerStrategy();

    private AdjacentVertexHasIdOptimizerStrategy() {
    }

    public static AdjacentVertexHasIdOptimizerStrategy instance() {
        return INSTANCE;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfClass(HasStep.class, traversal).forEach(this::optimizeStep);
    }

    private P<?> parsePredicate(HasStep<?> hasStep) {
        List hasContainers = hasStep.getHasContainers();
        if (hasContainers.size() != 1) {
            return null;
        }
        HasContainer hc = (HasContainer)hasContainers.get(0);
        if (hc.getKey().equals(T.id.getAccessor())) {
            return hc.getPredicate();
        }
        return null;
    }

    @Override
    protected boolean isValidStep(HasStep<?> step) {
        P<?> predicate = this.parsePredicate(step);
        if (predicate == null) {
            return false;
        }
        if (predicate.getBiPredicate() != Compare.eq) {
            return false;
        }
        Object predicateValue = predicate.getValue();
        return predicateValue instanceof Vertex || predicateValue instanceof Long;
    }

    @Override
    protected FilterStep<Edge> makeFilterByAdjacentIdStep(Traversal.Admin<?, ?> traversal, HasStep<?> originalStep) {
        HasContainer hc = new HasContainer(ImplicitKey.ADJACENT_ID.name(), P.eq((Object)this.parsePredicate(originalStep).getValue()));
        return new HasStep(traversal, new HasContainer[]{hc});
    }
}

