/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.index;

import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.index.IndexCandidate;
import org.janusgraph.graphdb.query.index.IndexSelectionStrategy;
import org.janusgraph.graphdb.query.index.IndexSelectionUtil;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.ParameterIndexField;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public abstract class AbstractIndexSelectionStrategy
implements IndexSelectionStrategy {
    private static final double EQUAL_CONDITION_SCORE = 4.0;
    private static final double OTHER_CONDITION_SCORE = 1.0;
    private static final double CARDINALITY_SINGE_SCORE = 1000.0;
    private static final double CARDINALITY_OTHER_SCORE = 1000.0;

    public AbstractIndexSelectionStrategy(Configuration config) {
    }

    @Override
    public IndexSelectionStrategy.SelectedIndexQuery selectIndices(ElementCategory resultType, MultiCondition<JanusGraphElement> conditions, Set<Condition> coveredClauses, OrderList orders, IndexSerializer serializer) {
        Set<IndexType> rawCandidates = this.createIndexRawCandidates(conditions, resultType, serializer);
        return this.selectIndices(rawCandidates, conditions, coveredClauses, orders, serializer);
    }

    protected Set<IndexType> createIndexRawCandidates(MultiCondition<JanusGraphElement> conditions, ElementCategory resultType, IndexSerializer serializer) {
        return IndexSelectionUtil.getMatchingIndexes(conditions, indexType -> indexType.getElement() == resultType && (!(conditions instanceof Or) || !indexType.isCompositeIndex() && serializer.features((MixedIndexType)indexType).supportNotQueryNormalForm()));
    }

    @Nullable
    protected IndexCandidate createIndexCandidate(IndexType index, MultiCondition<JanusGraphElement> conditions, IndexSerializer serializer) {
        Object subCondition;
        HashSet<Condition> subCover = new HashSet<Condition>(1);
        if (index.hasSchemaTypeConstraint()) {
            JanusGraphSchemaType type = index.getSchemaTypeConstraint();
            Map.Entry<Condition, Collection<Object>> equalCon = this.getEqualityConditionValues(conditions, ImplicitKey.LABEL);
            if (equalCon == null) {
                return null;
            }
            Collection<Object> labels = equalCon.getValue();
            assert (labels.size() >= 1);
            if (labels.size() > 1) {
                return null;
            }
            if (!type.name().equals(labels.iterator().next())) {
                return null;
            }
            subCover.add(equalCon.getKey());
        }
        if ((subCondition = index.isCompositeIndex() ? this.indexCover((CompositeIndexType)index, conditions, subCover) : this.indexCover((MixedIndexType)index, conditions, serializer, subCover)) == null || subCover.isEmpty()) {
            return null;
        }
        return new IndexCandidate(index, subCover, subCondition);
    }

    protected void addToJointQuery(IndexCandidate indexCandidate, JointIndexQuery jointQuery, IndexSerializer serializer, OrderList orders) {
        if (indexCandidate.getIndex().isCompositeIndex()) {
            jointQuery.add((CompositeIndexType)indexCandidate.getIndex(), serializer.getQuery((CompositeIndexType)indexCandidate.getIndex(), (List)indexCandidate.getSubCondition()));
        } else {
            jointQuery.add((MixedIndexType)indexCandidate.getIndex(), serializer.getQuery((MixedIndexType)indexCandidate.getIndex(), (Condition)indexCandidate.getSubCondition(), orders));
        }
    }

    protected double getConditionBasicScore(Condition c) {
        if (c instanceof PredicateCondition && ((PredicateCondition)c).getPredicate() == Cmp.EQUAL) {
            return 4.0;
        }
        return 1.0;
    }

    protected double getIndexTypeScore(IndexType index) {
        double score = 0.0;
        if (index.isCompositeIndex()) {
            score = ((CompositeIndexType)index).getCardinality() == Cardinality.SINGLE ? 1000.0 : 1000.0;
        }
        return score;
    }

    private List<Object[]> indexCover(CompositeIndexType index, Condition<JanusGraphElement> condition, Set<Condition> covered) {
        if (!QueryUtil.isQueryNormalForm(condition)) {
            return null;
        }
        assert (condition instanceof And);
        if (index.getStatus() != SchemaStatus.ENABLED) {
            return null;
        }
        IndexField[] fields = index.getFieldKeys();
        Object[] indexValues = new Object[fields.length];
        HashSet<Condition> coveredClauses = new HashSet<Condition>(fields.length);
        ArrayList<Object[]> indexCovers = new ArrayList<Object[]>(4);
        this.constructIndexCover(indexValues, 0, fields, condition, indexCovers, coveredClauses);
        if (!indexCovers.isEmpty()) {
            covered.addAll(coveredClauses);
            return indexCovers;
        }
        return null;
    }

    private void constructIndexCover(Object[] indexValues, int position, IndexField[] fields, Condition<JanusGraphElement> condition, List<Object[]> indexCovers, Set<Condition> coveredClauses) {
        if (position >= fields.length) {
            indexCovers.add(indexValues);
        } else {
            IndexField field = fields[position];
            Map.Entry<Condition, Collection<Object>> equalCon = this.getEqualityConditionValues(condition, field.getFieldKey());
            if (equalCon != null) {
                coveredClauses.add(equalCon.getKey());
                assert (equalCon.getValue().size() > 0);
                for (Object value : equalCon.getValue()) {
                    Object[] newValues = Arrays.copyOf(indexValues, fields.length);
                    newValues[position] = value;
                    this.constructIndexCover(newValues, position + 1, fields, condition, indexCovers, coveredClauses);
                }
            }
        }
    }

    private Condition<JanusGraphElement> indexCover(MixedIndexType index, Condition<JanusGraphElement> condition, IndexSerializer indexInfo, Set<Condition> covered) {
        if (!indexInfo.features(index).supportNotQueryNormalForm() && !QueryUtil.isQueryNormalForm(condition)) {
            return null;
        }
        if (condition instanceof Or) {
            for (Condition<JanusGraphElement> subClause : condition.getChildren()) {
                if (subClause instanceof And) {
                    for (Condition<JanusGraphElement> subsubClause : subClause.getChildren()) {
                        if (this.coversAll(index, subsubClause, indexInfo)) continue;
                        return null;
                    }
                    continue;
                }
                if (this.coversAll(index, subClause, indexInfo)) continue;
                return null;
            }
            covered.add(condition);
            return condition;
        }
        assert (condition instanceof And);
        And<JanusGraphElement> subCondition = new And<JanusGraphElement>(condition.numChildren());
        for (Condition<JanusGraphElement> subClause : condition.getChildren()) {
            if (!this.coversAll(index, subClause, indexInfo)) continue;
            subCondition.add(subClause);
            covered.add(subClause);
        }
        return subCondition.isEmpty() ? null : subCondition;
    }

    private boolean coversAll(MixedIndexType index, Condition<JanusGraphElement> condition, IndexSerializer indexInfo) {
        if (condition.getType() != Condition.Type.LITERAL) {
            return StreamSupport.stream(condition.getChildren().spliterator(), false).allMatch(child -> this.coversAll(index, (Condition<JanusGraphElement>)child, indexInfo));
        }
        if (!(condition instanceof PredicateCondition)) {
            return false;
        }
        PredicateCondition atom = (PredicateCondition)condition;
        if (atom.getValue() == null && atom.getPredicate() != Cmp.NOT_EQUAL) {
            return false;
        }
        Preconditions.checkArgument((boolean)((RelationType)atom.getKey()).isPropertyKey());
        PropertyKey key = (PropertyKey)atom.getKey();
        ParameterIndexField[] fields = index.getFieldKeys();
        ParameterIndexField match = Arrays.stream(fields).filter(field -> field.getStatus() == SchemaStatus.ENABLED).filter(field -> field.getFieldKey().equals(key)).findAny().orElse(null);
        if (match == null) {
            return false;
        }
        boolean existsQuery = atom.getValue() == null && atom.getPredicate() == Cmp.NOT_EQUAL && indexInfo.supportsExistsQuery(index, match);
        return existsQuery || indexInfo.supports(index, match, atom.getPredicate());
    }

    private Map.Entry<Condition, Collection<Object>> getEqualityConditionValues(Condition<JanusGraphElement> condition, RelationType type) {
        for (Condition<JanusGraphElement> c : condition.getChildren()) {
            PredicateCondition atom;
            if (c instanceof Or) {
                Map.Entry<RelationType, Collection> orEqual = QueryUtil.extractOrCondition((Or)c);
                if (orEqual == null || !orEqual.getKey().equals(type) || orEqual.getValue().isEmpty()) continue;
                return new AbstractMap.SimpleImmutableEntry<Condition, Collection<Object>>(c, orEqual.getValue());
            }
            if (!(c instanceof PredicateCondition) || !((RelationType)(atom = (PredicateCondition)c).getKey()).equals(type) || atom.getPredicate() != Cmp.EQUAL || atom.getValue() == null) continue;
            return new AbstractMap.SimpleImmutableEntry<Condition, Collection<Object>>(c, Collections.singletonList(atom.getValue()));
        }
        return null;
    }
}

