/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.janusgraph.core.schema.SchemaStatus;

public enum SchemaAction {
    REGISTER_INDEX(Collections.singleton(SchemaStatus.INSTALLED), Collections.singleton(SchemaStatus.DISABLED)),
    REINDEX(Arrays.asList(SchemaStatus.REGISTERED, SchemaStatus.ENABLED), Arrays.asList(SchemaStatus.INSTALLED, SchemaStatus.DISABLED)),
    ENABLE_INDEX(Collections.singleton(SchemaStatus.REGISTERED), Arrays.asList(SchemaStatus.INSTALLED, SchemaStatus.DISABLED)),
    DISABLE_INDEX(Arrays.asList(SchemaStatus.REGISTERED, SchemaStatus.INSTALLED, SchemaStatus.ENABLED), Collections.emptySet()),
    REMOVE_INDEX(Collections.singleton(SchemaStatus.DISABLED), Arrays.asList(SchemaStatus.REGISTERED, SchemaStatus.INSTALLED, SchemaStatus.ENABLED));

    private final Set<SchemaStatus> applicableStatuses;
    private final Set<SchemaStatus> failureStatuses;

    private SchemaAction(Collection<SchemaStatus> applicableStatuses, Collection<SchemaStatus> failureStatuses) {
        this.applicableStatuses = Collections.unmodifiableSet(new HashSet<SchemaStatus>(applicableStatuses));
        this.failureStatuses = Collections.unmodifiableSet(new HashSet<SchemaStatus>(failureStatuses));
    }

    public Set<SchemaStatus> getApplicableStatus() {
        return this.applicableStatuses;
    }

    public Set<SchemaStatus> getFailureStatus() {
        return this.failureStatuses;
    }

    public boolean isApplicableStatus(SchemaStatus status) {
        if (this.failureStatuses.contains((Object)status)) {
            throw new IllegalArgumentException(String.format("Update action [%s] cannot be invoked for index with status [%s]", new Object[]{this, status}));
        }
        return this.applicableStatuses.contains((Object)status);
    }
}

