/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.syncleus.ferma.ClassInitializer;
import com.syncleus.ferma.TVertex;
import com.syncleus.ferma.VertexFrame;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.ReflectionUtility;
import com.syncleus.ferma.typeresolvers.TypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.jboss.windup.graph.Adjacency;

public class WindupAdjacencyMethodHandler
extends AbstractMethodHandler {
    public Class<Adjacency> getAnnotationType() {
        return Adjacency.class;
    }

    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        Parameter[] arguments = method.getParameters();
        if (ReflectionUtility.isAddMethod((Method)method)) {
            if (arguments == null || arguments.length == 0) {
                return this.addVertexDefault(builder, method, annotation);
            }
            if (arguments.length == 1) {
                if (ClassInitializer.class.isAssignableFrom(arguments[0].getType())) {
                    return this.addVertexByTypeUntypedEdge(builder, method, annotation);
                }
                return this.addVertexByObjectUntypedEdge(builder, method, annotation);
            }
            if (arguments.length == 2) {
                if (!ClassInitializer.class.isAssignableFrom(arguments[1].getType())) {
                    throw new IllegalStateException(method.getName() + " was annotated with @Adjacency, had two arguments, but the second argument was not of the type ClassInitializer");
                }
                if (ClassInitializer.class.isAssignableFrom(arguments[0].getType())) {
                    return this.addVertexByTypeTypedEdge(builder, method, annotation);
                }
                return this.addVertexByObjectTypedEdge(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Adjacency but had more than 1 arguments.");
        }
        if (ReflectionUtility.isGetMethod((Method)method)) {
            if (arguments == null || arguments.length == 0) {
                if (ReflectionUtility.returnsIterator((Method)method)) {
                    return this.getVertexesIteratorDefault(builder, method, annotation);
                }
                if (ReflectionUtility.returnsList((Method)method)) {
                    return this.getVertexesListDefault(builder, method, annotation);
                }
                if (ReflectionUtility.returnsSet((Method)method)) {
                    return this.getVertexesSetDefault(builder, method, annotation);
                }
                return this.getVertexDefault(builder, method, annotation);
            }
            if (arguments.length == 1) {
                if (!Class.class.isAssignableFrom(arguments[0].getType())) {
                    throw new IllegalStateException(method.getName() + " was annotated with @Adjacency, had a single argument, but that argument was not of the type Class");
                }
                if (ReflectionUtility.returnsIterator((Method)method)) {
                    return this.getVertexesIteratorByType(builder, method, annotation);
                }
                if (ReflectionUtility.returnsList((Method)method)) {
                    return this.getVertexesListByType(builder, method, annotation);
                }
                if (ReflectionUtility.returnsSet((Method)method)) {
                    return this.getVertexesSetByType(builder, method, annotation);
                }
                return this.getVertexByType(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Adjacency but had more than 1 arguments.");
        }
        if (ReflectionUtility.isRemoveMethod((Method)method)) {
            if (arguments == null || arguments.length == 0) {
                return this.removeAll(builder, method, annotation);
            }
            if (arguments.length == 1) {
                return this.removeVertex(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Adjacency but had more than 1 arguments.");
        }
        if (ReflectionUtility.isSetMethod((Method)method)) {
            if (arguments == null || arguments.length == 0) {
                throw new IllegalStateException(method.getName() + " was annotated with @Adjacency but had no arguments.");
            }
            if (arguments.length == 1) {
                if (ReflectionUtility.acceptsIterator((Method)method, (int)0)) {
                    return this.setVertexIterator(builder, method, annotation);
                }
                if (ReflectionUtility.acceptsIterable((Method)method, (int)0)) {
                    return this.setVertexIterable(builder, method, annotation);
                }
                if (ReflectionUtility.acceptsVertexFrame((Method)method, (int)0)) {
                    return this.setVertexVertexFrame(builder, method, annotation);
                }
                throw new IllegalStateException(method.getName() + " was annotated with @Adjacency, had a single argument, but that argument was not of the type Iterator or Iterable");
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Adjacency but had more than 1 arguments.");
        }
        throw new IllegalStateException(method.getName() + " was annotated with @Adjacency but did not begin with either of the following keywords: add, get, remove");
    }

    private <E> DynamicType.Builder<E> getVertexesIteratorDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetVertexesIteratorDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getVertexesListDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetVertexesListDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getVertexesSetDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetVertexesSetDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getVertexDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetVertexDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getVertexesIteratorByType(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetVertexesIteratorByTypeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getVertexesListByType(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetVertexesListByTypeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getVertexesSetByType(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetVertexesSetByTypeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getVertexByType(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetVertexByTypeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addVertexDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddVertexDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addVertexByTypeUntypedEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddVertexByTypeUntypedEdgeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addVertexByObjectUntypedEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddVertexByObjectUntypedEdgeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addVertexByTypeTypedEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddVertexByTypeTypedEdgeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addVertexByObjectTypedEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddVertexByObjectTypedEdgeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> setVertexIterator(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(SetVertexIteratorInterceptor.class));
    }

    private <E> DynamicType.Builder<E> setVertexIterable(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(SetVertexIterableInterceptor.class));
    }

    private <E> DynamicType.Builder<E> setVertexVertexFrame(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(SetVertexVertexFrameInterceptor.class));
    }

    private <E> DynamicType.Builder<E> removeVertex(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(RemoveVertexInterceptor.class));
    }

    private <E> DynamicType.Builder<E> removeAll(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(RemoveAllInterceptor.class));
    }

    public static final class RemoveAllInterceptor {
        @RuntimeType
        public static void removeVertex(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    GraphTraversal bothEdges = thiz.getRawTraversal().bothE(new String[]{label});
                    bothEdges.forEachRemaining(new Consumer<Edge>(){

                        @Override
                        public void accept(Edge edge) {
                            edge.remove();
                        }
                    });
                    break;
                }
                case IN: {
                    GraphTraversal inEdges = thiz.getRawTraversal().inE(new String[]{label});
                    inEdges.forEachRemaining(new Consumer<Edge>(){

                        @Override
                        public void accept(Edge edge) {
                            edge.remove();
                        }
                    });
                    break;
                }
                case OUT: {
                    GraphTraversal outEdges = thiz.getRawTraversal().outE(new String[]{label});
                    outEdges.forEachRemaining(new Consumer<Edge>(){

                        @Override
                        public void accept(Edge edge) {
                            edge.remove();
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
        }
    }

    public static final class RemoveVertexInterceptor {
        @RuntimeType
        public static void removeVertex(@This VertexFrame thiz, @Origin Method method, final @RuntimeType @Argument(value=0) VertexFrame removeVertex) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    GraphTraversal bothEdges = thiz.getRawTraversal().bothE(new String[]{label});
                    bothEdges.forEachRemaining(new Consumer<Edge>(){

                        @Override
                        public void accept(Edge edge) {
                            if (null == removeVertex || edge.outVertex().id().equals(removeVertex.getId()) || edge.inVertex().id().equals(removeVertex.getId())) {
                                edge.remove();
                            }
                        }
                    });
                    break;
                }
                case IN: {
                    GraphTraversal inEdges = thiz.getRawTraversal().inE(new String[]{label});
                    inEdges.forEachRemaining(new Consumer<Edge>(){

                        @Override
                        public void accept(Edge edge) {
                            if (null == removeVertex || edge.outVertex().id().equals(removeVertex.getId())) {
                                edge.remove();
                            }
                        }
                    });
                    break;
                }
                case OUT: {
                    GraphTraversal outEdges = thiz.getRawTraversal().outE(new String[]{label});
                    outEdges.forEachRemaining(new Consumer<Edge>(){

                        @Override
                        public void accept(Edge edge) {
                            if (null == removeVertex || edge.inVertex().id().equals(removeVertex.getId())) {
                                edge.remove();
                            }
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
        }
    }

    public static final class SetVertexVertexFrameInterceptor {
        @RuntimeType
        public static void setVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) VertexFrame vertexFrame) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            if (vertexFrame == null) {
                RemoveAllInterceptor.removeVertex(thiz, method);
                return;
            }
            switch (direction) {
                case BOTH: {
                    thiz.unlinkBoth(null, new String[]{label});
                    thiz.getGraph().addFramedEdge(vertexFrame, thiz, label);
                    thiz.getGraph().addFramedEdge(thiz, vertexFrame, label);
                    break;
                }
                case IN: {
                    thiz.unlinkIn(null, new String[]{label});
                    thiz.getGraph().addFramedEdge(vertexFrame, thiz, label);
                    break;
                }
                case OUT: {
                    thiz.unlinkOut(null, new String[]{label});
                    thiz.getGraph().addFramedEdge(thiz, vertexFrame, label);
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
        }
    }

    public static final class SetVertexIterableInterceptor {
        @RuntimeType
        public static void setVertex(final @This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Iterable vertexSet) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            final String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    thiz.unlinkBoth(null, new String[]{label});
                    vertexSet.iterator().forEachRemaining(new Consumer<VertexFrame>(){

                        @Override
                        public void accept(VertexFrame vertexFrame) {
                            thiz.getGraph().addFramedEdge(vertexFrame, thiz, label);
                            thiz.getGraph().addFramedEdge(thiz, vertexFrame, label);
                        }
                    });
                    break;
                }
                case IN: {
                    thiz.unlinkIn(null, new String[]{label});
                    vertexSet.iterator().forEachRemaining(new Consumer<VertexFrame>(){

                        @Override
                        public void accept(VertexFrame vertexFrame) {
                            thiz.getGraph().addFramedEdge(vertexFrame, thiz, label);
                        }
                    });
                    break;
                }
                case OUT: {
                    thiz.unlinkOut(null, new String[]{label});
                    vertexSet.iterator().forEachRemaining(new Consumer<VertexFrame>(){

                        @Override
                        public void accept(VertexFrame vertexFrame) {
                            thiz.getGraph().addFramedEdge(thiz, vertexFrame, label);
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
        }
    }

    public static final class SetVertexIteratorInterceptor {
        @RuntimeType
        public static void setVertex(final @This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Iterator vertexSet) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            final String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    thiz.unlinkBoth(null, new String[]{label});
                    vertexSet.forEachRemaining(new Consumer<VertexFrame>(){

                        @Override
                        public void accept(VertexFrame vertexFrame) {
                            thiz.getGraph().addFramedEdge(vertexFrame, thiz, label);
                            thiz.getGraph().addFramedEdge(thiz, vertexFrame, label);
                        }
                    });
                    break;
                }
                case IN: {
                    thiz.unlinkIn(null, new String[]{label});
                    vertexSet.forEachRemaining(new Consumer<VertexFrame>(){

                        @Override
                        public void accept(VertexFrame vertexFrame) {
                            thiz.getGraph().addFramedEdge(vertexFrame, thiz, label);
                        }
                    });
                    break;
                }
                case OUT: {
                    thiz.unlinkOut(null, new String[]{label});
                    vertexSet.forEachRemaining(new Consumer<VertexFrame>(){

                        @Override
                        public void accept(VertexFrame vertexFrame) {
                            thiz.getGraph().addFramedEdge(thiz, vertexFrame, label);
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
        }
    }

    public static final class AddVertexByObjectTypedEdgeInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) VertexFrame newVertex, @RuntimeType @Argument(value=1) ClassInitializer edgeType) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    thiz.getGraph().addFramedEdge(newVertex, thiz, label, edgeType, new Object[0]);
                    thiz.getGraph().addFramedEdge(thiz, newVertex, label, edgeType, new Object[0]);
                    break;
                }
                case IN: {
                    thiz.getGraph().addFramedEdge(newVertex, thiz, label, edgeType, new Object[0]);
                    break;
                }
                case OUT: {
                    thiz.getGraph().addFramedEdge(thiz, newVertex, label, edgeType, new Object[0]);
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
            return newVertex;
        }
    }

    public static final class AddVertexByObjectUntypedEdgeInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) VertexFrame newVertex) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    thiz.getGraph().addFramedEdge(newVertex, thiz, label);
                    thiz.getGraph().addFramedEdge(thiz, newVertex, label);
                    break;
                }
                case IN: {
                    thiz.getGraph().addFramedEdge(newVertex, thiz, label);
                    break;
                }
                case OUT: {
                    thiz.getGraph().addFramedEdge(thiz, newVertex, label);
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
            return newVertex;
        }
    }

    public static final class AddVertexByTypeTypedEdgeInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) ClassInitializer vertexType, @RuntimeType @Argument(value=1) ClassInitializer edgeType) {
            Object newNode = thiz.getGraph().addFramedVertex(vertexType, new Object[0]);
            assert (newNode instanceof VertexFrame);
            VertexFrame newVertex = (VertexFrame)newNode;
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            assert (vertexType.getInitializationType().isInstance(newNode));
            switch (direction) {
                case BOTH: {
                    thiz.getGraph().addFramedEdge(newVertex, thiz, label, edgeType, new Object[0]);
                    thiz.getGraph().addFramedEdge(thiz, newVertex, label, edgeType, new Object[0]);
                    break;
                }
                case IN: {
                    thiz.getGraph().addFramedEdge(newVertex, thiz, label, edgeType, new Object[0]);
                    break;
                }
                case OUT: {
                    thiz.getGraph().addFramedEdge(thiz, newVertex, label, edgeType, new Object[0]);
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
            return newNode;
        }
    }

    public static final class AddVertexByTypeUntypedEdgeInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) ClassInitializer vertexType) {
            Object newNode = thiz.getGraph().addFramedVertex(vertexType, new Object[0]);
            assert (newNode instanceof VertexFrame);
            VertexFrame newVertex = (VertexFrame)newNode;
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            assert (vertexType.getInitializationType().isInstance(newNode));
            switch (direction) {
                case BOTH: {
                    thiz.getGraph().addFramedEdge(newVertex, thiz, label);
                    thiz.getGraph().addFramedEdge(thiz, newVertex, label);
                    break;
                }
                case IN: {
                    thiz.getGraph().addFramedEdge(newVertex, thiz, label);
                    break;
                }
                case OUT: {
                    thiz.getGraph().addFramedEdge(thiz, newVertex, label);
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
            return newNode;
        }
    }

    public static final class AddVertexDefaultInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method) {
            TVertex newVertex = thiz.getGraph().addFramedVertex();
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    thiz.getGraph().addFramedEdge((VertexFrame)newVertex, thiz, label);
                    thiz.getGraph().addFramedEdge(thiz, (VertexFrame)newVertex, label);
                    break;
                }
                case IN: {
                    thiz.getGraph().addFramedEdge((VertexFrame)newVertex, thiz, label);
                    break;
                }
                case OUT: {
                    thiz.getGraph().addFramedEdge(thiz, (VertexFrame)newVertex, label);
                    break;
                }
                default: {
                    throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
                }
            }
            return newVertex;
        }
    }

    public static final class GetVertexByTypeInterceptor {
        @RuntimeType
        public static Object getVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Class type) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            TypeResolver resolver = thiz.getGraph().getTypeResolver();
            return thiz.traverse(input -> {
                switch (direction) {
                    case IN: {
                        return resolver.hasType(input.in(new String[]{label}), type);
                    }
                    case OUT: {
                        return resolver.hasType(input.out(new String[]{label}), type);
                    }
                    case BOTH: {
                        return resolver.hasType(input.both(new String[]{label}), type);
                    }
                }
                throw new IllegalStateException("Direction not recognized.");
            }).next(type);
        }
    }

    public static final class GetVertexDefaultInterceptor {
        @RuntimeType
        public static Object getVertexes(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            try {
                return thiz.traverse(input -> {
                    switch (direction) {
                        case IN: {
                            return input.in(new String[]{label});
                        }
                        case OUT: {
                            return input.out(new String[]{label});
                        }
                        case BOTH: {
                            return input.both(new String[]{label});
                        }
                    }
                    throw new IllegalStateException("Direction not recognized.");
                }).next(VertexFrame.class);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }

    public static final class GetVertexesSetByTypeInterceptor {
        @RuntimeType
        public static Set getVertexes(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Class type) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            TypeResolver resolver = thiz.getGraph().getTypeResolver();
            return thiz.traverse(input -> {
                switch (direction) {
                    case IN: {
                        return resolver.hasType(input.in(new String[]{label}), type);
                    }
                    case OUT: {
                        return resolver.hasType(input.out(new String[]{label}), type);
                    }
                    case BOTH: {
                        return resolver.hasType(input.both(new String[]{label}), type);
                    }
                }
                throw new IllegalStateException("Direction not recognized.");
            }).toSet(type);
        }
    }

    public static final class GetVertexesListByTypeInterceptor {
        @RuntimeType
        public static List getVertexes(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Class type) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            TypeResolver resolver = thiz.getGraph().getTypeResolver();
            return thiz.traverse(input -> {
                switch (direction) {
                    case IN: {
                        return resolver.hasType(input.in(new String[]{label}), type);
                    }
                    case OUT: {
                        return resolver.hasType(input.out(new String[]{label}), type);
                    }
                    case BOTH: {
                        return resolver.hasType(input.both(new String[]{label}), type);
                    }
                }
                throw new IllegalStateException("Direction not recognized.");
            }).toList(type);
        }
    }

    public static final class GetVertexesIteratorByTypeInterceptor {
        @RuntimeType
        public static Iterator getVertexes(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Class type) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            TypeResolver resolver = thiz.getGraph().getTypeResolver();
            return thiz.traverse(input -> {
                switch (direction) {
                    case IN: {
                        return resolver.hasType(input.in(new String[]{label}), type);
                    }
                    case OUT: {
                        return resolver.hasType(input.out(new String[]{label}), type);
                    }
                    case BOTH: {
                        return resolver.hasType(input.both(new String[]{label}), type);
                    }
                }
                throw new IllegalStateException("Direction not recognized.");
            }).frame(type);
        }
    }

    public static final class GetVertexesSetDefaultInterceptor {
        @RuntimeType
        public static Set getVertexes(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            return thiz.traverse(input -> {
                switch (direction) {
                    case IN: {
                        return input.in(new String[]{label});
                    }
                    case OUT: {
                        return input.out(new String[]{label});
                    }
                    case BOTH: {
                        return input.both(new String[]{label});
                    }
                }
                throw new IllegalStateException("Direction not recognized.");
            }).toSet(VertexFrame.class);
        }
    }

    public static final class GetVertexesListDefaultInterceptor {
        @RuntimeType
        public static List getVertexes(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            return thiz.traverse(input -> {
                switch (direction) {
                    case IN: {
                        return input.in(new String[]{label});
                    }
                    case OUT: {
                        return input.out(new String[]{label});
                    }
                    case BOTH: {
                        return input.both(new String[]{label});
                    }
                }
                throw new IllegalStateException("Direction not recognized.");
            }).toList(VertexFrame.class);
        }
    }

    public static final class GetVertexesIteratorDefaultInterceptor {
        @RuntimeType
        public static Iterator getVertexes(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Adjacency annotation = (Adjacency)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Adjacency.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            return thiz.traverse(input -> {
                switch (direction) {
                    case IN: {
                        return input.in(new String[]{label});
                    }
                    case OUT: {
                        return input.out(new String[]{label});
                    }
                    case BOTH: {
                        return input.both(new String[]{label});
                    }
                }
                throw new IllegalStateException("Direction not recognized.");
            }).frame(VertexFrame.class);
        }
    }
}

