/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.MethodHandler;
import com.syncleus.ferma.framefactories.annotation.ReflectionUtility;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.graph.SetInProperties;
import org.jboss.windup.util.exception.WindupException;

public class SetInPropertiesHandler
extends AbstractMethodHandler
implements MethodHandler {
    private static final String SET_VERTEX_PROP_VALUE = "1";

    public Class<SetInProperties> getAnnotationType() {
        return SetInProperties.class;
    }

    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        String methodName = method.getName();
        if (ReflectionUtility.isGetMethod((Method)method)) {
            return this.createInterceptor(builder, method);
        }
        if (ReflectionUtility.isSetMethod((Method)method)) {
            return this.createInterceptor(builder, method);
        }
        if (methodName.startsWith("addAll")) {
            return this.createInterceptor(builder, method);
        }
        if (methodName.startsWith("add")) {
            return this.createInterceptor(builder, method);
        }
        throw new WindupException("Only get*, set*, add*, and addAll* method names are supported for @" + SetInProperties.class.getSimpleName() + ", found at: " + method.getName());
    }

    private <E> DynamicType.Builder<E> createInterceptor(DynamicType.Builder<E> builder, Method method) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(SetInPropertiesMethodInterceptor.class));
    }

    public static final class SetInPropertiesMethodInterceptor {
        @RuntimeType
        public static Object execute(@This ElementFrame thisFrame, @Origin Method method, @RuntimeType @AllArguments Object[] args) {
            SetInProperties ann = (SetInProperties)((CachesReflection)thisFrame).getReflectionCache().getAnnotation(method, SetInProperties.class);
            Element thisElement = thisFrame.getElement();
            if (!(thisElement instanceof Vertex)) {
                throw new WindupException("Element is not of supported type, must be Vertex, but was: " + thisElement.getClass().getCanonicalName());
            }
            Vertex vertex = (Vertex)thisElement;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                return SetInPropertiesMethodInterceptor.handleGetter(vertex, method, args, ann);
            }
            if (methodName.startsWith("set")) {
                SetInPropertiesMethodInterceptor.handleSetter(vertex, method, args, ann);
            } else if (methodName.startsWith("addAll")) {
                SetInPropertiesMethodInterceptor.handleAddAll(vertex, method, args, ann);
            } else if (methodName.startsWith("add")) {
                SetInPropertiesMethodInterceptor.handleAdder(vertex, method, args, ann);
            } else {
                throw new WindupException("Only get*, set*, add*, and addAll* method names are supported for @" + SetInProperties.class.getSimpleName() + ", found at: " + method.getName());
            }
            return thisFrame;
        }

        private static Set<String> handleGetter(Vertex vertex, Method method, Object[] args, SetInProperties ann) {
            if (args != null && args.length != 0) {
                throw new WindupException("Method must take zero arguments");
            }
            HashSet<String> set = new HashSet<String>();
            String prefix = SetInPropertiesMethodInterceptor.preparePrefix(ann);
            Set keys = vertex.keys();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                String tail = key = (String)iterator.next();
                if (!prefix.isEmpty()) {
                    if (!key.startsWith(prefix)) continue;
                    tail = key.substring(prefix.length());
                }
                set.add(tail);
            }
            return set;
        }

        private static void handleSetter(Vertex vertex, Method method, Object[] args, SetInProperties ann) {
            if (args == null || args.length != 1) {
                throw new WindupException("Method must take one argument: " + method.getName());
            }
            if (!(args[0] instanceof Set)) {
                throw new WindupException("Argument of " + method.getName() + " must be a Set<String>, but is: " + args[0].getClass());
            }
            Set newSet = (Set)args[0];
            String prefix = SetInPropertiesMethodInterceptor.preparePrefix(ann);
            Set vertKeys = vertex.keys();
            for (String vertKey : vertKeys) {
                if (!vertKey.startsWith(prefix) || "w:winduptype".equals(vertKey) || vertKey.startsWith("w:")) continue;
                String subKey = vertKey.substring(prefix.length());
                if (newSet.contains(subKey)) {
                    vertex.property(vertKey, (Object)SetInPropertiesHandler.SET_VERTEX_PROP_VALUE);
                    newSet.remove(subKey);
                    continue;
                }
                vertex.property(vertKey).remove();
            }
            for (String item : newSet) {
                if (!(item instanceof String)) {
                    throw new WindupException("Argument of " + method.getName() + " must be a Set<String>, but it contains: " + item.getClass());
                }
                vertex.property(prefix + item, (Object)SetInPropertiesHandler.SET_VERTEX_PROP_VALUE);
            }
        }

        private static void handleAdder(Vertex vertex, Method method, Object[] args, SetInProperties ann) {
            if (args == null || args.length == 0) {
                throw new WindupException("Method must take at least one String argument: " + method.getName());
            }
            String prefix = SetInPropertiesMethodInterceptor.preparePrefix(ann);
            for (Object arg : args) {
                if (!(arg instanceof String)) {
                    throw new WindupException("The arguments of the add*() method " + method.getName() + " must be String, but was: " + arg.getClass());
                }
                vertex.property(prefix + arg, (Object)SetInPropertiesHandler.SET_VERTEX_PROP_VALUE);
            }
        }

        private static void handleAddAll(Vertex vertex, Method method, Object[] args, SetInProperties ann) {
            if (args == null || args.length != 1) {
                throw new WindupException("Method must take one String argument: " + method.getName());
            }
            String prefix = SetInPropertiesMethodInterceptor.preparePrefix(ann);
            Set set = (Set)args[0];
            for (String item : set) {
                vertex.property(prefix + item, (Object)SetInPropertiesHandler.SET_VERTEX_PROP_VALUE);
            }
        }

        private static String preparePrefix(SetInProperties ann) {
            return "".equals(ann.propertyPrefix()) ? "" : ann.propertyPrefix() + ":";
        }
    }
}

