/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.tags.Tag;
import org.jboss.windup.config.tags.TagService;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TagModel;
import org.jboss.windup.util.exception.WindupException;

public class TagGraphService
extends GraphService<TagModel> {
    public static final Logger LOG = Logger.getLogger(TagGraphService.class.getName());

    public TagGraphService(GraphContext context) {
        super(context, TagModel.class);
    }

    public TagModel getTagByName(String name) {
        if (null == name) {
            throw new IllegalArgumentException("Looking for a null tag name.");
        }
        return (TagModel)this.getUniqueByProperty("name", name.toLowerCase());
    }

    public void feedTheWholeTagStructureToGraph(TagService tagLoaderService) {
        HashSet<Tag> visited = new HashSet<Tag>();
        for (Tag tag : tagLoaderService.getRootTags()) {
            TagModel existing = (TagModel)this.getUniqueByProperty("name", tag.getName());
            if (null != existing) {
                LOG.warning("TagModel already exists in graph, skipping root Tag: " + tag.getName());
                return;
            }
            int level = 0;
            this.feedTagStructureToGraph(tag, visited, level);
        }
    }

    private TagModel feedTagStructureToGraph(Tag tag, Set<Tag> visited, int level) {
        if (visited.contains(tag)) {
            return (TagModel)this.getUniqueByProperty("name", tag.getName(), true);
        }
        visited.add(tag);
        LOG.fine(String.format("Creating TagModel for Tag: %s%s(%d)   '%s'  traits: %s", StringUtils.repeat((char)' ', (int)(level * 2)), tag.getName(), tag.getContainedTags().size(), tag.getTitle(), tag.getTraits()));
        TagModel tagModel = (TagModel)this.create();
        tagModel.setName(tag.getName());
        tagModel.setTitle(tag.getTitle());
        tagModel.setColor(tag.getColor());
        tagModel.setRoot(tag.isPrime());
        tagModel.setPseudo(tag.isPseudo());
        if (null != tag.getTraits()) {
            tagModel.putAllTraits(tag.getTraits());
        }
        tag.getContainedTags().forEach(tag2 -> {
            TagModel tag2model = this.feedTagStructureToGraph((Tag)tag2, visited, level + 1);
            tagModel.addDesignatedTag(tag2model);
        });
        return tagModel;
    }

    public Set<TagModel> getDescendantTags(TagModel tag) {
        HashSet<TagModel> ancestors = new HashSet<TagModel>();
        this.getDescendantTags(tag, ancestors);
        return ancestors;
    }

    private void getDescendantTags(TagModel tag, Set<TagModel> putResultsHere) {
        for (TagModel childTag : tag.getDesignatedTags()) {
            if (!putResultsHere.add(childTag)) continue;
            this.getDescendantTags(childTag, putResultsHere);
        }
    }

    public static boolean isTagUnderTagOrSame(TagModel subTag, TagModel superTag) {
        return TagGraphService.isTagUnderTag(subTag, superTag, true);
    }

    public static boolean isTagUnderTag(TagModel subTag, TagModel superTag, boolean countIfSame) {
        LinkedHashSet<TagModel> nextSet;
        if (superTag == null) {
            throw new IllegalArgumentException("Super tag param was null. Sub tag: " + subTag);
        }
        if (subTag == null) {
            throw new IllegalArgumentException("Sub tag param was null. Super tag: " + superTag);
        }
        if (superTag.getName().equals(subTag.getName())) {
            return true;
        }
        HashSet walkedSet = new HashSet();
        HashSet<TagModel> currentSet = new HashSet<TagModel>();
        currentSet.add(subTag);
        do {
            walkedSet.addAll(currentSet);
            nextSet = new LinkedHashSet<TagModel>();
            for (TagModel currentTag : currentSet) {
                for (TagModel parent : currentTag.getDesignatedByTags()) {
                    if (superTag.equals(parent)) {
                        return true;
                    }
                    nextSet.add(parent);
                }
            }
            for (TagModel walkedTag : walkedSet) {
                if (!nextSet.contains(walkedTag)) continue;
                nextSet.remove(walkedTag);
            }
        } while (!(currentSet = nextSet).isEmpty());
        return false;
    }

    public static TagModel getSingleParent(TagModel tag) {
        Iterator<TagModel> parents = tag.getDesignatedByTags().iterator();
        if (!parents.hasNext()) {
            throw new WindupException("Tag is not designated by any tags: " + tag);
        }
        TagModel maybeOnlyParent = parents.next();
        if (parents.hasNext()) {
            StringBuilder sb = new StringBuilder();
            tag.getDesignatedByTags().iterator().forEachRemaining(x -> sb.append(x).append(", "));
            throw new WindupException(String.format("Tag %s is designated by multiple tags: %s", tag, sb.toString()));
        }
        return maybeOnlyParent;
    }
}

