/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.syncleus.ferma.FramedGraph;
import com.syncleus.ferma.VertexFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.FramedVertexIterable;
import org.jboss.windup.graph.model.FileReferenceModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.IssueDisplayMode;
import org.jboss.windup.reporting.service.EffortAccumulatorFunction;
import org.jboss.windup.reporting.service.MapSumEffortAccumulatorFunction;
import org.jboss.windup.reporting.service.SetMembersFilter;

public class InlineHintService
extends GraphService<InlineHintModel> {
    public static final Logger LOG = Logger.getLogger(InlineHintService.class.getName());

    public InlineHintService(GraphContext context) {
        super(context, InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFileReference(FileReferenceModel reference) {
        GraphTraversal inlineHintPipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{reference.getElement()});
        inlineHintPipeline.in(new String[]{"InlineHintModel-fileLocationReference"});
        inlineHintPipeline.has("w:winduptype", (P)Text.textContains((Object)"InlineHintModel"));
        return new FramedVertexIterable((FramedGraph)this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline.toList(), InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFile(FileModel file) {
        GraphTraversal inlineHintPipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{file.getElement()});
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("w:winduptype", (P)Text.textContains((Object)"InlineHintModel"));
        return new FramedVertexIterable((FramedGraph)this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline.toList(), InlineHintModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GraphTraversal inlineHintPipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{fileModel.getElement()});
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("EffortReportModelEffort", P.gt((Object)0));
        inlineHintPipeline.has("w:winduptype", (P)Text.textContains((Object)"InlineHintModel"));
        int hintEffort = 0;
        for (Vertex v : inlineHintPipeline.toList()) {
            hintEffort += ((Integer)v.property("EffortReportModelEffort").value()).intValue();
        }
        return hintEffort;
    }

    private List<Vertex> getProjectAndChildren(ProjectModel projectModel) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        result.add(projectModel.getElement());
        for (ProjectModel child : projectModel.getChildProjects()) {
            result.addAll(this.getProjectAndChildren(child));
        }
        return result;
    }

    public Iterable<InlineHintModel> getHintsForProject(ProjectModel projectModel, boolean recursive) {
        List<Vertex> initialVertices = recursive ? this.getProjectAndChildren(projectModel) : Collections.singletonList(projectModel.getElement());
        return this.getInlineHintModels(initialVertices);
    }

    public Iterable<InlineHintModel> getHintsForProjects(List<ProjectModel> projectModels) {
        List<Vertex> projectVertexList = projectModels.stream().map(VertexFrame::getElement).collect(Collectors.toList());
        return this.getInlineHintModels(projectVertexList);
    }

    private Iterable<InlineHintModel> getInlineHintModels(List<Vertex> initialProjectVertices) {
        GraphTraversal inlineHintPipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{initialProjectVertices});
        inlineHintPipeline.out(new String[]{"projectModelToFile"});
        inlineHintPipeline.in(new String[]{"file"}).has("w:winduptype", P.eq((Object)"InlineHintModel"));
        LinkedHashSet<InlineHintModel> results = new LinkedHashSet<InlineHintModel>();
        for (Vertex v : inlineHintPipeline.toList()) {
            results.add((InlineHintModel)this.frame(v));
        }
        return results;
    }

    public Map<Integer, Integer> getMigrationEffortByPoints(ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, Set<String> issueCategoryIDs, boolean recursive, boolean includeZero) {
        MapSumEffortAccumulatorFunction accumulator = new MapSumEffortAccumulatorFunction(){

            public Object vertexToKey(Vertex effortReportVertex) {
                Integer migrationEffort = (Integer)effortReportVertex.property("EffortReportModelEffort").value();
                return migrationEffort;
            }
        };
        this.getMigrationEffortDetails(traversal, includeTags, excludeTags, issueCategoryIDs, recursive, includeZero, accumulator);
        return accumulator.getResults();
    }

    public Map<IssueCategoryModel, Integer> getMigrationEffortBySeverity(GraphRewrite event, ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, Set<String> issueCategoryIDs, boolean recursive) {
        MapSumEffortAccumulatorFunction<IssueCategoryModel> accumulator = new MapSumEffortAccumulatorFunction<IssueCategoryModel>(){

            @Override
            public IssueCategoryModel vertexToKey(Vertex effortReportVertex) {
                return ((InlineHintModel)InlineHintService.this.frame(effortReportVertex)).getIssueCategory();
            }

            @Override
            public void accumulate(Vertex effortReportVertex) {
                if (((InlineHintModel)InlineHintService.this.frame(effortReportVertex)).getIssueDisplayMode() == IssueDisplayMode.DETAIL_ONLY) {
                    return;
                }
                super.accumulate(effortReportVertex);
            }
        };
        this.getMigrationEffortDetails(traversal, includeTags, excludeTags, issueCategoryIDs, recursive, true, accumulator);
        return accumulator.getResults();
    }

    private void getMigrationEffortDetails(ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, Set<String> issueCategoryIDs, boolean recursive, boolean includeZero, EffortAccumulatorFunction accumulatorFunction) {
        LOG.log(Level.INFO, String.format(System.lineSeparator() + "\t\t\tEFFORT H: getMigrationEffortDetails() with: %s, %srecur, %sincludeZero, %s, tags: %s, excl: %s", traversal, recursive ? "" : "!", includeZero ? "" : "!", accumulatorFunction, includeTags, excludeTags));
        Set initialVertices = traversal.getAllProjectsAsVertices(recursive);
        GraphTraversal pipeline = this.getGraphContext().getGraph().traversal().V(new Object[0]);
        if (!includeZero) {
            pipeline.has("EffortReportModelEffort", P.gt((Object)0));
            pipeline.has("w:winduptype", (P)Text.textContains((Object)"InlineHintModel"));
        } else {
            pipeline.has("w:winduptype", (Object)"InlineHintModel");
        }
        pipeline.as("hint", new String[0]);
        pipeline.out(new String[]{"file"});
        pipeline.in(new String[]{"projectModelToFile"});
        pipeline.filter((Predicate)new SetMembersFilter(initialVertices));
        pipeline.select("hint");
        boolean checkTags = !includeTags.isEmpty() || !excludeTags.isEmpty();
        for (Vertex v : pipeline.toSet()) {
            if (checkTags || !issueCategoryIDs.isEmpty()) {
                InlineHintModel hintModel = (InlineHintModel)this.frame(v);
                if (checkTags && !hintModel.matchesTags(includeTags, excludeTags) || !issueCategoryIDs.isEmpty() && !issueCategoryIDs.contains(hintModel.getIssueCategory().getCategoryID())) continue;
            }
            accumulatorFunction.accumulate(v);
        }
    }
}

