/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.syncleus.ferma.FramedGraph;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.FramedVertexIterable;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.IssueDisplayMode;
import org.jboss.windup.reporting.service.ClassificationServiceCache;
import org.jboss.windup.reporting.service.EffortAccumulatorFunction;
import org.jboss.windup.reporting.service.MapSumEffortAccumulatorFunction;
import org.jboss.windup.reporting.service.SetMembersFilter;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ClassificationService
extends GraphService<ClassificationModel> {
    public static final Logger LOG = Logger.getLogger(ClassificationService.class.getName());

    public ClassificationService(GraphContext context) {
        super(context, ClassificationModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GraphTraversal classificationPipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{fileModel.getElement()});
        classificationPipeline.in(new String[]{"ClassificationModel-classificationModelToFileModel"});
        classificationPipeline.has("EffortReportModelEffort", P.gt((Object)0));
        classificationPipeline.has("w:winduptype", (P)Text.textContains((Object)"ClassificationModel"));
        int classificationEffort = 0;
        for (Vertex v : classificationPipeline.toList()) {
            VertexProperty migrationEffort = v.property("EffortReportModelEffort");
            if (!migrationEffort.isPresent()) continue;
            classificationEffort += ((Integer)migrationEffort.value()).intValue();
        }
        return classificationEffort;
    }

    public Iterable<ClassificationModel> getClassifications(FileModel model) {
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{model.getElement()});
        pipeline.in(new String[]{"ClassificationModel-classificationModelToFileModel"});
        pipeline.has("w:winduptype", (P)Text.textContains((Object)"ClassificationModel"));
        return new FramedVertexIterable((FramedGraph)this.getGraphContext().getFramed(), (Iterable)pipeline.toList(), ClassificationModel.class);
    }

    public Iterable<ClassificationModel> getClassificationByName(FileModel model, String classificationName) {
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{model.getElement()});
        pipeline.in(new String[]{"ClassificationModel-classificationModelToFileModel"});
        pipeline.has("w:winduptype", (P)Text.textContains((Object)"ClassificationModel"));
        pipeline.has("ClassificationModel-classification", (Object)classificationName);
        return new FramedVertexIterable((FramedGraph)this.getGraphContext().getFramed(), (Iterable)pipeline.toList(), ClassificationModel.class);
    }

    public Map<Integer, Integer> getMigrationEffortByPoints(ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, Set<String> issueCategoryIDs, boolean recursive, boolean includeZero) {
        MapSumEffortAccumulatorFunction accumulator = new MapSumEffortAccumulatorFunction(){

            public Integer vertexToKey(Vertex effortReportVertex) {
                Integer migrationEffort = (Integer)effortReportVertex.property("EffortReportModelEffort").value();
                return migrationEffort;
            }
        };
        this.getMigrationEffortDetails(traversal, includeTags, excludeTags, issueCategoryIDs, recursive, includeZero, accumulator);
        return accumulator.getResults();
    }

    public Map<IssueCategoryModel, Integer> getMigrationEffortBySeverity(GraphRewrite event, ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, Set<String> issueCategoryIDs, boolean recursive) {
        MapSumEffortAccumulatorFunction<IssueCategoryModel> accumulator = new MapSumEffortAccumulatorFunction<IssueCategoryModel>(){

            @Override
            public IssueCategoryModel vertexToKey(Vertex effortReportVertex) {
                return ((ClassificationModel)ClassificationService.this.frame(effortReportVertex)).getIssueCategory();
            }

            @Override
            public void accumulate(Vertex effortReportVertex) {
                if (((ClassificationModel)ClassificationService.this.frame(effortReportVertex)).getIssueDisplayMode() == IssueDisplayMode.DETAIL_ONLY) {
                    return;
                }
                super.accumulate(effortReportVertex);
            }
        };
        this.getMigrationEffortDetails(traversal, includeTags, excludeTags, issueCategoryIDs, recursive, true, accumulator);
        return accumulator.getResults();
    }

    private void getMigrationEffortDetails(ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, Set<String> issueCategoryIDs, boolean recursive, boolean includeZero, EffortAccumulatorFunction accumulatorFunction) {
        LOG.log(Level.INFO, String.format(System.lineSeparator() + "\t\t\tEFFORT C: getMigrationEffortDetails() with: %s, %srecur, %sincludeZero, %s, tags: %s, excl: %s", traversal, recursive ? "" : "!", includeZero ? "" : "!", accumulatorFunction, includeTags, excludeTags));
        Set initialVertices = traversal.getAllProjectsAsVertices(recursive);
        GraphTraversal pipeline = this.getGraphContext().getGraph().traversal().V(new Object[0]);
        if (!includeZero) {
            pipeline.has("EffortReportModelEffort", P.gt((Object)0));
            pipeline.has("w:winduptype", P.eq((Object)"ClassificationModel"));
        } else {
            pipeline.has("w:winduptype", (Object)"ClassificationModel");
        }
        pipeline.as("classification", new String[0]);
        pipeline.out(new String[]{"ClassificationModel-classificationModelToFileModel"});
        pipeline.in(new String[]{"projectModelToFile"});
        pipeline.filter((Predicate)new SetMembersFilter(initialVertices));
        pipeline.select("classification");
        boolean checkTags = !includeTags.isEmpty() || !excludeTags.isEmpty();
        FileService fileService = new FileService(this.getGraphContext());
        for (Vertex v : pipeline.toSet()) {
            if (checkTags || !issueCategoryIDs.isEmpty()) {
                ClassificationModel classificationModel = (ClassificationModel)this.frame(v);
                if (checkTags && !classificationModel.matchesTags(includeTags, excludeTags) || !issueCategoryIDs.isEmpty() && !issueCategoryIDs.contains(classificationModel.getIssueCategory().getCategoryID())) continue;
            }
            Iterator fileVertexIterator = v.vertices(Direction.OUT, new String[]{"ClassificationModel-classificationModelToFileModel"});
            while (fileVertexIterator.hasNext()) {
                Vertex fileVertex = (Vertex)fileVertexIterator.next();
                FileModel fileModel = (FileModel)fileService.frame(fileVertex);
                if (!initialVertices.contains(fileModel.getProjectModel().getElement())) continue;
                accumulatorFunction.accumulate(v);
            }
        }
    }

    public ClassificationModel attachClassification(GraphRewrite event, Rule rule, FileModel fileModel, String classificationText, String description) {
        return this.attachClassification(event, rule, fileModel, "optional", classificationText, description);
    }

    public ClassificationModel attachClassification(GraphRewrite event, Rule rule, FileModel fileModel, String categoryId, String classificationTitle, String description) {
        GraphTraversal classificationTraversal = this.getQuery().traverse(g -> g.has("ClassificationModel-classification", (Object)classificationTitle)).getRawTraversal();
        ClassificationModel classification = (ClassificationModel)this.getUnique((Traversal)classificationTraversal);
        if (classification == null) {
            classification = (ClassificationModel)this.create();
            classification.setClassification(classificationTitle);
            classification.setDescription(description);
            classification.setEffort(0);
            IssueCategoryModel cat = IssueCategoryRegistry.loadFromGraph(event.getGraphContext(), categoryId);
            classification.setIssueCategory(cat);
            classification.setRuleID(rule.getId());
            if (fileModel instanceof DuplicateArchiveModel) {
                fileModel = ((DuplicateArchiveModel)fileModel).getCanonicalArchive();
            }
            classification.addFileModel(fileModel);
            if (fileModel instanceof SourceFileModel) {
                ((SourceFileModel)fileModel).setGenerateSourceReport(true);
            }
            ClassificationServiceCache.cacheClassificationFileModel(event, classification, fileModel, true);
            return classification;
        }
        if (!StringUtils.equals((CharSequence)description, (CharSequence)classification.getDescription())) {
            LOG.warning("The description of the newly attached classification differs from the same-titled existing one, so the old description is being changed." + System.lineSeparator() + "   Clsf title: " + classification.getClassification() + System.lineSeparator() + "   Old desc: " + classification.getDescription() + System.lineSeparator() + "   New desc: " + description);
        }
        classification.setDescription(description);
        return this.attachClassification(event, classification, fileModel);
    }

    public ClassificationModel attachClassification(GraphRewrite event, EvaluationContext context, FileModel fileModel, String classificationText, String description) {
        return this.attachClassification(event, context, fileModel, "optional", classificationText, description);
    }

    public ClassificationModel attachClassification(GraphRewrite event, EvaluationContext context, FileModel fileModel, String categoryId, String classificationText, String description) {
        Rule rule = (Rule)context.get(Rule.class);
        return this.attachClassification(event, rule, fileModel, categoryId, classificationText, description);
    }

    private boolean isClassificationLinkedToFileModel(GraphRewrite event, ClassificationModel classificationModel, FileModel fileModel) {
        return ClassificationServiceCache.isClassificationLinkedToFileModel(event, classificationModel, fileModel);
    }

    public ClassificationModel attachClassification(GraphRewrite event, ClassificationModel classificationModel, FileModel fileModel) {
        if (fileModel instanceof DuplicateArchiveModel) {
            fileModel = ((DuplicateArchiveModel)fileModel).getCanonicalArchive();
        }
        if (!this.isClassificationLinkedToFileModel(event, classificationModel, fileModel)) {
            classificationModel.addFileModel(fileModel);
            if (fileModel instanceof SourceFileModel) {
                ((SourceFileModel)fileModel).setGenerateSourceReport(true);
            }
        }
        ClassificationServiceCache.cacheClassificationFileModel(event, classificationModel, fileModel, true);
        return classificationModel;
    }

    public ClassificationModel attachLink(ClassificationModel classificationModel, LinkModel linkModel) {
        for (LinkModel existing : classificationModel.getLinks()) {
            if (!StringUtils.equals((CharSequence)existing.getLink(), (CharSequence)linkModel.getLink())) continue;
            return classificationModel;
        }
        classificationModel.addLink(linkModel);
        return classificationModel;
    }
}

