/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.LabelLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.Label;
import org.jboss.windup.config.metadata.LabelProviderRegistry;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.rules.AttachApplicationReportsToIndexRuleProvider;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=PostReportGenerationPhase.class, before={AttachApplicationReportsToIndexRuleProvider.class}, haltOnException=true)
public class CreateApplicationListReportRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(CreateApplicationListReportRuleProvider.class);
    public static final String APPLICATION_LIST_REPORT = "Application List";
    private static final String OUTPUT_FILENAME = "../index.html";
    public static final String TEMPLATE_PATH = "/reports/templates/application_list.ftl";
    @Inject
    private Furnace furnace;
    @Inject
    private LabelLoader labelLoader;

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                CreateApplicationListReportRuleProvider.this.createIndexReport(event.getGraphContext());
            }
        });
    }

    private void createIndexReport(GraphContext context) {
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        List userLabelPaths = cfg.getUserLabelsPaths().stream().map(fileModel -> fileModel.asFile().toPath()).collect(Collectors.toList());
        ArrayList labels = new ArrayList();
        RuleLoaderContext labelLoaderContext = new RuleLoaderContext(userLabelPaths, null);
        LabelProviderRegistry labelProviderRegistry = this.labelLoader.loadConfiguration(labelLoaderContext);
        for (Object provider : labelProviderRegistry.getProviders()) {
            labels.addAll(provider.getData().getLabels());
        }
        JsonArrayBuilder labelsJsonArrayBuilder = Json.createArrayBuilder();
        for (Label label : labels) {
            labelsJsonArrayBuilder.add((JsonValue)this.toJson(label));
        }
        JsonArray labelsJsonArray = labelsJsonArrayBuilder.build();
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel report = applicationReportService.create();
        report.setReportPriority(1);
        report.setReportIconClass("glyphicon glyphicon-home");
        report.setReportName(APPLICATION_LIST_REPORT);
        report.setTemplatePath(TEMPLATE_PATH);
        report.setTemplateType(TemplateType.FREEMARKER);
        report.setDisplayInApplicationReportIndex(false);
        report.setReportFilename(OUTPUT_FILENAME);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("target_runtimes", labelsJsonArray.toString());
        report.setReportProperties(properties);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        HashMap<String, WindupVertexFrame> relatedData = new HashMap<String, WindupVertexFrame>();
        List apps = applicationReportService.findAll();
        ArrayList<ApplicationReportModel> appsList = new ArrayList<ApplicationReportModel>();
        for (ApplicationReportModel applicationReportModel : apps) {
            if (applicationReportModel.isMainApplicationReport() == null || !applicationReportModel.isMainApplicationReport().booleanValue()) continue;
            appsList.add(applicationReportModel);
            if (!"<shared-libs>".equals(applicationReportModel.getProjectModel().getUniqueID())) continue;
            relatedData.put("sharedLibsApplicationReport", applicationReportModel);
        }
        Collections.sort(appsList, new AppRootFileNameComparator());
        WindupVertexListModel appsListVertex = (WindupVertexListModel)listService.create();
        relatedData.put("applications", appsListVertex);
        for (ApplicationReportModel applicationReportModel : appsList) {
            appsListVertex.addItem(applicationReportModel);
        }
        report.setRelatedResource(relatedData);
    }

    private JsonObject toJson(Label label) {
        JsonArrayBuilder supportedJsonArrayBuilder = Json.createArrayBuilder();
        JsonArrayBuilder unsuitableJsonArrayBuilder = Json.createArrayBuilder();
        JsonArrayBuilder neutralJsonArrayBuilder = Json.createArrayBuilder();
        label.getSupported().forEach(arg_0 -> ((JsonArrayBuilder)supportedJsonArrayBuilder).add(arg_0));
        label.getUnsuitable().forEach(arg_0 -> ((JsonArrayBuilder)unsuitableJsonArrayBuilder).add(arg_0));
        label.getNeutral().forEach(arg_0 -> ((JsonArrayBuilder)neutralJsonArrayBuilder).add(arg_0));
        return Json.createObjectBuilder().add("id", label.getId()).add("name", label.getName()).add("description", label.getDescription() != null ? label.getDescription() : "").add("supported", (JsonValue)supportedJsonArrayBuilder.build()).add("unsuitable", (JsonValue)unsuitableJsonArrayBuilder.build()).add("neutral", (JsonValue)neutralJsonArrayBuilder.build()).build();
    }

    public static class AppRootFileNameComparator
    implements Comparator<ApplicationReportModel> {
        @Override
        public int compare(ApplicationReportModel o1, ApplicationReportModel o2) {
            if (null == o1.getProjectModel() || null == o1.getProjectModel().getRootFileModel() || null == o1.getProjectModel().getRootFileModel().getFileName()) {
                return 1;
            }
            if (null == o2.getProjectModel() || null == o2.getProjectModel().getRootFileModel() || null == o2.getProjectModel().getRootFileModel().getFileName()) {
                return -1;
            }
            try {
                return o1.getProjectModel().getRootFileModel().getFileName().compareToIgnoreCase(o2.getProjectModel().getRootFileModel().getFileName());
            }
            catch (Throwable ex) {
                return 0;
            }
        }
    }
}

