/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.ruleexecution;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.graph.GraphListener;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionInformation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class RuleExecutionResultsListener
implements RuleLifecycleListener {
    private final IdentityHashMap<Rule, RuleExecutionInformation> ruleExecutionInformation = new IdentityHashMap();
    private GraphRewrite event;
    private Rule currentRule = null;

    public static RuleExecutionResultsListener instance(GraphRewrite event) {
        return (RuleExecutionResultsListener)event.getRewriteContext().get(RuleExecutionResultsListener.class);
    }

    public List<RuleExecutionInformation> getRuleExecutionInformation(AbstractRuleProvider provider) {
        RuleProviderRegistry ruleExecutionMetadata = RuleProviderRegistry.instance((GraphRewrite)this.event);
        List rules = ruleExecutionMetadata.getRules((RuleProvider)provider);
        ArrayList<RuleExecutionInformation> allRuleExecutions = new ArrayList<RuleExecutionInformation>();
        for (Rule rule : rules) {
            allRuleExecutions.add(this.ruleExecutionInformation.get(rule));
        }
        return allRuleExecutions;
    }

    public void beforeExecution(GraphRewrite event) {
        this.ruleExecutionInformation.clear();
        this.event = event;
        event.getRewriteContext().put(RuleExecutionResultsListener.class, (Object)this);
        event.getGraphContext().registerGraphListener((GraphListener)new RuleExecutionGraphListener());
    }

    public boolean beforeRuleEvaluation(GraphRewrite event, Rule rule, EvaluationContext context) {
        this.ruleExecutionInformation.put(rule, new RuleExecutionInformation(rule));
        this.currentRule = rule;
        return false;
    }

    public boolean ruleEvaluationProgress(GraphRewrite event, String name, int currentPosition, int total, int timeRemainingInSeconds) {
        return false;
    }

    public void afterRuleConditionEvaluation(GraphRewrite event, EvaluationContext context, Rule rule, boolean result) {
        this.ruleExecutionInformation.get(rule).setEvaluationResult(result);
        if (!result) {
            this.currentRule = null;
        }
    }

    public boolean beforeRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
        return false;
    }

    public void afterRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
        this.ruleExecutionInformation.get(rule).setExecuted(true);
        this.currentRule = null;
    }

    public void afterRuleExecutionFailed(GraphRewrite event, EvaluationContext context, Rule rule, Throwable failureCause) {
        this.ruleExecutionInformation.get(rule).setFailed(true);
        this.ruleExecutionInformation.get(rule).setFailureCause(failureCause);
        this.currentRule = null;
    }

    public void afterExecution(GraphRewrite event) {
    }

    private class RuleExecutionGraphListener
    implements GraphListener {
        private RuleExecutionGraphListener() {
        }

        public synchronized void vertexAdded(Vertex vertex) {
            if (RuleExecutionResultsListener.this.currentRule != null) {
                RuleExecutionResultsListener.this.ruleExecutionInformation.get(RuleExecutionResultsListener.this.currentRule).addVertexIDAdded(vertex.id());
            }
        }

        public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
        }
    }
}

