/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.model;

import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.reporting.TagUtil;
import org.jboss.windup.reporting.model.TagSetModel;

@TypeValue(value="TaggableModel")
public interface TaggableModel
extends WindupVertexFrame {
    public static final String CATCHALL_TAG = "catchall";
    public static final String TYPE = "TaggableModel";
    public static final String TAG = "tag";

    @Adjacency(label="tag", direction=Direction.OUT)
    public void setTagModel(TagSetModel var1);

    @Adjacency(label="tag", direction=Direction.OUT)
    public TagSetModel getTagModelNotNullSafe();

    default public TagSetModel getTagModel() {
        try {
            return this.getTagModelNotNullSafe();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    default public Set<String> getTags() {
        TagSetModel tagSetModel = this.getTagModel();
        if (tagSetModel == null) {
            return Collections.emptySet();
        }
        return tagSetModel.getTags();
    }

    default public boolean matchesTags(Set<String> includeTags, Set<String> excludeTags) {
        return TagUtil.checkMatchingTags(this.getTags(), includeTags, excludeTags);
    }
}

