/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.MapInAdjacentVertices;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.reporting.model.TemplateType;

@TypeValue(value="ReportModel")
public interface ReportModel
extends WindupVertexFrame {
    public static final String TYPE = "ReportModel";
    public static final String CHILD_REPORT = "childReport";
    public static final String RELATED_RESOURCES = "relatedResources";
    public static final String PARENT_REPORT = "parentReport";
    public static final String TEMPLATE_TYPE = "templateType";
    public static final String TEMPLATE_PATH = "templatePath";
    public static final String REPORT_FILENAME = "reportFilename";
    public static final String REPORT_ICON_CLASS = "reportIconClass";
    public static final String REPORT_NAME = "reportName";
    public static final String DESCRIPTION = "reportDescription";

    @Property(value="reportName")
    public void setReportName(String var1);

    @Property(value="reportName")
    public String getReportName();

    @Property(value="reportDescription")
    public void setDescription(String var1);

    @Property(value="reportDescription")
    public String getDescription();

    @Property(value="reportFilename")
    public void setReportFilename(String var1);

    @Property(value="reportFilename")
    public String getReportFilename();

    @Indexed
    @Property(value="templatePath")
    public void setTemplatePath(String var1);

    @Property(value="templatePath")
    public String getTemplatePath();

    @Property(value="templateType")
    public void setTemplateType(TemplateType var1);

    @Property(value="templateType")
    public TemplateType getTemplateType();

    @Property(value="reportIconClass")
    public String getReportIconClass();

    @Property(value="reportIconClass")
    public void setReportIconClass(String var1);

    @Adjacency(label="parentReport", direction=Direction.IN)
    public ReportModel getParentReport();

    @Adjacency(label="parentReport", direction=Direction.IN)
    public void setParentReport(ReportModel var1);

    @MapInAdjacentVertices(label="relatedResources")
    public void setRelatedResource(Map<String, WindupVertexFrame> var1);

    @MapInAdjacentVertices(label="relatedResources")
    public Map<String, WindupVertexFrame> getRelatedResources();

    @Adjacency(label="childReport", direction=Direction.OUT)
    public List<ReportModel> getChildReports();

    @Adjacency(label="childReport", direction=Direction.OUT)
    public void addChildReport(ReportModel var1);

    default public List<ReportModel> getAllParentsInReversedOrder() {
        ArrayList<ReportModel> reports = new ArrayList<ReportModel>();
        ReportModel currentReport = this;
        reports.add(this);
        while (currentReport.getParentReport() != null) {
            reports.add(currentReport.getParentReport());
            currentReport = currentReport.getParentReport();
        }
        Collections.reverse(reports);
        return reports;
    }
}

