/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.TagUtil;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.freemarker.problemsummary.RuleSummaryKey;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.IssueDisplayMode;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;

public class ProblemSummaryService {
    public static Map<IssueCategoryModel, List<ProblemSummary>> getProblemSummaries(GraphContext graphContext, Set<ProjectModel> projectModels, Set<String> includeTags, Set<String> excludeTags) {
        return ProblemSummaryService.getProblemSummaries(graphContext, projectModels, includeTags, excludeTags, false, false);
    }

    public static Map<IssueCategoryModel, List<ProblemSummary>> getProblemSummaries(GraphContext graphContext, Set<ProjectModel> projectModels, Set<String> includeTags, Set<String> excludeTags, boolean strictComparison, boolean strictExclude) {
        TreeMap<IssueCategoryModel, List<ProblemSummary>> results = new TreeMap<IssueCategoryModel, List<ProblemSummary>>(new IssueCategoryModel.IssueSummaryPriorityComparator());
        HashMap<RuleSummaryKey, Object> ruleToSummary = new HashMap<RuleSummaryKey, Object>();
        InlineHintService hintService = new InlineHintService(graphContext);
        List hints = projectModels == null ? hintService.findAll() : hintService.getHintsForProjects(new ArrayList<ProjectModel>(projectModels));
        for (InlineHintModel hint : hints) {
            if (hint.getIssueDisplayMode() == IssueDisplayMode.DETAIL_ONLY) continue;
            Set tags = hint.getTags();
            boolean hasTagMatch = strictComparison ? TagUtil.strictCheckMatchingTags(tags, includeTags, excludeTags) : TagUtil.checkMatchingTags(tags, includeTags, excludeTags, strictExclude);
            if (!hasTagMatch) continue;
            RuleSummaryKey key = new RuleSummaryKey(hint.getEffort(), hint.getRuleID(), hint.getTitle());
            Object summary = (ProblemSummary)ruleToSummary.get(key);
            if (summary == null) {
                List<String> sourceTechnologies = hint.getSourceTechnologies().stream().map(TechnologyReference::new).map(TechnologyReference::toString).collect(Collectors.toList());
                List<String> targetTechnologies = hint.getTargetTechnologies().stream().map(TechnologyReference::new).map(TechnologyReference::toString).collect(Collectors.toList());
                summary = new ProblemSummary(UUID.randomUUID().toString(), hint.getIssueCategory(), hint.getRuleID(), hint.getTitle(), 1, hint.getEffort(), sourceTechnologies, targetTechnologies);
                for (LinkModel link : hint.getLinks()) {
                    ((ProblemSummary)summary).addLink(link.getDescription(), link.getLink());
                }
                ruleToSummary.put(key, summary);
                ProblemSummaryService.addToResults(results, (ProblemSummary)summary);
            } else {
                ((ProblemSummary)summary).setNumberFound(((ProblemSummary)summary).getNumberFound() + 1);
            }
            ((ProblemSummary)summary).addFile(hint.getHint(), hint.getFile());
        }
        ClassificationService classificationService = new ClassificationService(graphContext);
        for (ClassificationModel classification : classificationService.findAll()) {
            Set tags;
            if (classification.getIssueDisplayMode() == IssueDisplayMode.DETAIL_ONLY || !TagUtil.checkMatchingTags(tags = classification.getTags(), includeTags, excludeTags, false)) continue;
            ArrayList<FileModel> newFileModels = new ArrayList<FileModel>();
            for (FileModel file : classification.getFileModels()) {
                if (projectModels != null && !projectModels.contains(file.getProjectModel())) continue;
                newFileModels.add(file);
            }
            if (newFileModels.isEmpty()) continue;
            RuleSummaryKey key = new RuleSummaryKey(classification.getEffort(), classification.getRuleID(), classification.getClassification());
            ProblemSummary summary = (ProblemSummary)ruleToSummary.get(key);
            if (summary == null) {
                List<String> sourceTechnologies = classification.getSourceTechnologies().stream().map(TechnologyReference::new).map(TechnologyReference::toString).collect(Collectors.toList());
                List<String> targetTechnologies = classification.getTargetTechnologies().stream().map(TechnologyReference::new).map(TechnologyReference::toString).collect(Collectors.toList());
                summary = new ProblemSummary(UUID.randomUUID().toString(), classification.getIssueCategory(), classification.getRuleID(), classification.getClassification(), 0, classification.getEffort(), sourceTechnologies, targetTechnologies);
                for (LinkModel link : classification.getLinks()) {
                    summary.addLink(link.getDescription(), link.getLink());
                }
                ruleToSummary.put(key, summary);
                ProblemSummaryService.addToResults(results, summary);
            }
            for (FileModel file : newFileModels) {
                summary.addFile(classification.getDescription(), file);
            }
            summary.setNumberFound(summary.getNumberFound() + newFileModels.size());
        }
        return results;
    }

    private static void addToResults(Map<IssueCategoryModel, List<ProblemSummary>> results, ProblemSummary summary) {
        List<ProblemSummary> list = results.get(summary.getIssueCategoryModel());
        if (list == null) {
            list = new ArrayList<ProblemSummary>();
            results.put(summary.getIssueCategoryModel(), list);
        }
        list.add(summary);
    }
}

