/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModelException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.traversal.OnlyOnceTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummaryService;

public class GetProblemSummariesMethod
implements WindupFreeMarkerMethod {
    private GraphContext context;

    @Override
    public String getDescription() {
        return "Returns a summary of all classification and hints found during analysis in the form of a List<" + ProblemSummary.class.getSimpleName() + ">.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.isEmpty()) {
            throw new TemplateModelException("Method " + this.getMethodName() + " requires the following parameters (GraphRewrite event, ProjectModel project, Set<String> includeTags, Set<String> excludeTags)");
        }
        GraphRewrite event = (GraphRewrite)((StringModel)arguments.get(0)).getWrappedObject();
        StringModel projectModelArg = (StringModel)arguments.get(1);
        ProjectModel projectModel = projectModelArg == null ? null : (ProjectModel)projectModelArg.getWrappedObject();
        Set<String> includeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)arguments.get(2));
        Set<String> excludeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)arguments.get(3));
        Set<ProjectModel> projectModels = this.getProjects(projectModel);
        Map<IssueCategoryModel, List<ProblemSummary>> problemSummariesOriginal = ProblemSummaryService.getProblemSummaries(event.getGraphContext(), projectModels, includeTags, excludeTags);
        IssueCategoryModel.IssueSummaryPriorityComparator severityComparator = new IssueCategoryModel.IssueSummaryPriorityComparator();
        TreeMap<IssueCategoryModel, List<ProblemSummary>> problemSummaries = new TreeMap<IssueCategoryModel, List<ProblemSummary>>(severityComparator);
        problemSummaries.putAll(problemSummariesOriginal);
        LinkedHashMap<String, List> primarySummariesByString = new LinkedHashMap<String, List>(problemSummariesOriginal.size());
        for (Map.Entry entry : problemSummaries.entrySet()) {
            String severityString = entry.getKey() == null ? null : ((IssueCategoryModel)entry.getKey()).getName();
            primarySummariesByString.put(severityString, (List)entry.getValue());
        }
        return primarySummariesByString;
    }

    private Set<ProjectModel> getProjects(ProjectModel projectModel) {
        if (projectModel == null) {
            return null;
        }
        ProjectModelTraversal traversal = new ProjectModelTraversal(projectModel, (TraversalStrategy)new OnlyOnceTraversalStrategy());
        return traversal.getAllProjects(true);
    }

    @Override
    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }
}

