/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.ExecutionStatistics;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class FreeMarkerIterationOperation
extends AbstractIterationOperation<ReportModel> {
    private static final Logger LOG = Logger.getLogger(FreeMarkerIterationOperation.class.getName());
    private static final String DEFAULT_ITERATION_PAYLOAD_NAME = "reportModel";
    private static final String FM_VAR_EVENT = "event";
    private static final String FM_VAR_WINDUP_CONFIG = "windupConfig";
    private static final String FM_VAR_INPUT_PATHS = "inputPaths";
    private static final String FM_VAR_APPS = "inputApplications";
    private final Furnace furnace;
    private final Set<String> variableNames = new HashSet<String>();
    private final boolean useDefaultPayloadVariableName;

    protected FreeMarkerIterationOperation(Furnace furnace, String ... varNames) {
        this.furnace = furnace;
        this.useDefaultPayloadVariableName = true;
        if (varNames != null) {
            this.variableNames.addAll(Arrays.asList(varNames));
        }
    }

    protected FreeMarkerIterationOperation(Furnace furnace, String iterationVarName, String ... varNames) {
        super(iterationVarName);
        this.furnace = furnace;
        this.useDefaultPayloadVariableName = false;
        this.variableNames.add(iterationVarName);
        if (varNames != null) {
            this.variableNames.addAll(Arrays.asList(varNames));
        }
    }

    public static FreeMarkerIterationOperation create(Furnace furnace, String ... varNames) {
        return new FreeMarkerIterationOperation(furnace, varNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(final GraphRewrite event, EvaluationContext evalCtx, ReportModel payload) {
        String templatePath = payload.getTemplatePath().replace('\\', '/');
        String outputFilename = payload.getReportFilename();
        ExecutionStatistics.get().begin("FreeMarkerIterationOperation.render(" + templatePath + ", " + outputFilename + ")");
        try {
            GraphContext grCtx = event.getGraphContext();
            ReportService reportService = new ReportService(grCtx);
            Path outputPath = reportService.getReportDirectory().resolve(outputFilename);
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            LOG.info("Reporting: Writing template \"" + templatePath + "\" to output file \"" + outputPath.toAbsolutePath().toString() + "\"");
            Configuration freemarkerConfig = FreeMarkerUtil.getDefaultFreemarkerConfiguration();
            Template template = freemarkerConfig.getTemplate(templatePath);
            Variables windupVarStack = Variables.instance((GraphRewrite)event);
            Map<String, Object> freeMarkerTemplateVariables = FreeMarkerUtil.findFreeMarkerContextVariables(windupVarStack, this.variableNames.toArray(new String[this.variableNames.size()]));
            if (this.useDefaultPayloadVariableName) {
                freeMarkerTemplateVariables.put(DEFAULT_ITERATION_PAYLOAD_NAME, payload);
            }
            freeMarkerTemplateVariables.put(FM_VAR_EVENT, event);
            WindupConfigurationModel windupConfigModel = WindupConfigurationService.getConfigurationModel((GraphContext)grCtx);
            freeMarkerTemplateVariables.put(FM_VAR_WINDUP_CONFIG, windupConfigModel);
            freeMarkerTemplateVariables.put(FM_VAR_INPUT_PATHS, windupConfigModel.getInputPaths());
            freeMarkerTemplateVariables.put(FM_VAR_APPS, new ProjectService(grCtx).getRootProjectModels());
            Map freeMarkerExtensions = (Map)this.furnace.getLockManager().performLocked(LockMode.WRITE, (Callable)new Callable<Map<String, Object>>(){

                @Override
                public Map<String, Object> call() throws Exception {
                    return FreeMarkerUtil.findFreeMarkerExtensions(FreeMarkerIterationOperation.this.furnace, event);
                }
            });
            HashMap<String, Object> objects = new HashMap<String, Object>(freeMarkerTemplateVariables);
            objects.putAll(freeMarkerExtensions);
            try (FileWriter fw = new FileWriter(outputPath.toFile());){
                template.process(objects, (Writer)fw);
            }
        }
        catch (TemplateException | IOException e) {
            LOG.log(Level.WARNING, System.lineSeparator() + "   Failed to write template: " + templatePath + System.lineSeparator() + "   To: " + outputFilename + System.lineSeparator() + "   Due to: " + e.getMessage(), e);
        }
        finally {
            ExecutionStatistics.get().end("FreeMarkerIterationOperation.render(" + templatePath + ", " + outputFilename + ")");
        }
    }

    public String toString() {
        return "RenderFreeMarkerTemplate";
    }
}

