/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.graph.model.TechnologyReferenceModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;

public class TechnologiesIntersector {
    public static List<TechnologyReferenceModel> extractSourceTechnologies(WindupConfigurationModel configuration, RuleProviderMetadata ruleProviderMetadata) {
        List configuredSourceTechnologies = configuration.getSourceTechnologies();
        Set ruleSourceTechnologies = ruleProviderMetadata.getSourceTechnologies();
        return TechnologiesIntersector.intersectTechnologies(configuredSourceTechnologies, ruleSourceTechnologies);
    }

    public static List<TechnologyReferenceModel> extractTargetTechnologies(WindupConfigurationModel configuration, RuleProviderMetadata ruleProviderMetadata) {
        List configuredTargetTechnologies = configuration.getTargetTechnologies();
        Set ruleTargetTechnologies = ruleProviderMetadata.getTargetTechnologies();
        return TechnologiesIntersector.intersectTechnologies(configuredTargetTechnologies, ruleTargetTechnologies);
    }

    private static List<TechnologyReferenceModel> intersectTechnologies(Collection<TechnologyReferenceModel> configuredTechnologies, Collection<TechnologyReference> ruleTechnologies) {
        return configuredTechnologies.stream().filter(confTech -> {
            TechnologyReference confTechRef = new TechnologyReference(confTech);
            return ruleTechnologies.stream().anyMatch(arg_0 -> ((TechnologyReference)confTechRef).matches(arg_0));
        }).collect(Collectors.toList());
    }
}

