/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class ClassificationExists
extends GraphCondition {
    private String filename;
    private String classificationPattern;

    private ClassificationExists(String classificationPattern) {
        this.classificationPattern = "[\\s\\S]*" + classificationPattern + "[\\s\\S]*";
    }

    public static ClassificationExists withClassification(String classificationPattern) {
        return new ClassificationExists(classificationPattern);
    }

    public ClassificationExists in(String filename) {
        this.filename = filename;
        return this;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        QueryBuilderFind q = Query.fromType(ClassificationModel.class);
        if (StringUtils.isNotBlank((CharSequence)this.filename)) {
            q.piped(new QueryGremlinCriterion(){
                private static final String CLASSIFICATION_STEP = "classificationModel";

                public void query(GraphRewrite event, GraphTraversal<?, Vertex> pipeline) {
                    pipeline.as(CLASSIFICATION_STEP, new String[0]);
                    pipeline.out(new String[]{"ClassificationModel-classificationModelToFileModel"});
                    pipeline.has("fileName", (Object)ClassificationExists.this.filename);
                    pipeline.select(CLASSIFICATION_STEP);
                }
            });
        }
        q.withProperty("ClassificationModel-classification", QueryPropertyComparisonType.REGEX, (Object)this.classificationPattern);
        return q.evaluate((Rewrite)event, context);
    }
}

